/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.sphere.sdk.channels.Channel;
import io.sphere.sdk.channels.ChannelDraft;
import io.sphere.sdk.channels.ChannelDraftBuilder;
import io.sphere.sdk.channels.ChannelDraftDsl;
import io.sphere.sdk.channels.ChannelRole;
import io.sphere.sdk.channels.commands.ChannelCreateCommand;
import io.sphere.sdk.channels.expansion.ChannelExpansionModel;
import io.sphere.sdk.channels.queries.ChannelQuery;
import io.sphere.sdk.channels.queries.ChannelQueryBuilder;
import io.sphere.sdk.channels.queries.ChannelQueryModel;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class ChannelServiceImpl
extends BaseServiceWithKey<ChannelDraft, Channel, BaseSyncOptions, ChannelQuery, ChannelQueryModel, ChannelExpansionModel<Channel>>
implements ChannelService {
    private final Set<ChannelRole> channelRoles;

    public ChannelServiceImpl(@Nonnull BaseSyncOptions syncOptions, @Nonnull Set<ChannelRole> channelRoles) {
        super(syncOptions);
        this.channelRoles = channelRoles;
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedChannelId(@Nonnull String key) {
        return this.fetchCachedResourceId(key, () -> ChannelQueryBuilder.of().plusPredicates(queryModel -> queryModel.key().is(key)).build());
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Channel>> createChannel(@Nonnull String key) {
        ChannelDraftDsl draft = ChannelDraftBuilder.of((String)key).roles(this.channelRoles).build();
        return this.createResource(draft, ChannelCreateCommand::of);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Channel>> createAndCacheChannel(@Nonnull String key) {
        return this.createChannel(key).thenApply(channelOptional -> {
            channelOptional.ifPresent(channel -> this.keyToIdCache.put(key, channel.getId()));
            return channelOptional;
        });
    }
}

