/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.sync.commons.models.WaitingToBeResolvedTransitions;
import com.commercetools.sync.services.UnresolvedTransitionsService;
import com.commercetools.sync.states.StateSyncOptions;
import io.sphere.sdk.client.SphereClient;
import io.sphere.sdk.client.SphereRequest;
import io.sphere.sdk.customobjects.CustomObject;
import io.sphere.sdk.customobjects.CustomObjectDraft;
import io.sphere.sdk.customobjects.commands.CustomObjectDeleteCommand;
import io.sphere.sdk.customobjects.commands.CustomObjectUpsertCommand;
import io.sphere.sdk.customobjects.queries.CustomObjectQuery;
import io.sphere.sdk.queries.QueryDsl;
import io.sphere.sdk.queries.QueryExecutionUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;

public class UnresolvedTransitionsServiceImpl
implements UnresolvedTransitionsService {
    private final StateSyncOptions syncOptions;
    private static final String SAVE_FAILED = "Failed to save CustomObject with key: '%s' (hash of state key: '%s').";
    private static final String DELETE_FAILED = "Failed to delete CustomObject with key: '%s' (hash of state key: '%s').";
    private static final String CUSTOM_OBJECT_CONTAINER_KEY = "commercetools-sync-java.UnresolvedTransitionsService.stateDrafts";

    public UnresolvedTransitionsServiceImpl(@Nonnull StateSyncOptions baseSyncOptions) {
        this.syncOptions = baseSyncOptions;
    }

    @Nonnull
    private String hash(@Nullable String customObjectKey) {
        return DigestUtils.sha1Hex((String)customObjectKey);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<WaitingToBeResolvedTransitions>> fetch(@Nonnull Set<String> keys) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        Set hashedKeys = keys.stream().map(this::hash).collect(Collectors.toSet());
        CustomObjectQuery customObjectQuery = (CustomObjectQuery)CustomObjectQuery.of(WaitingToBeResolvedTransitions.class).byContainer(CUSTOM_OBJECT_CONTAINER_KEY).plusPredicates(p -> p.key().isIn((Iterable)hashedKeys));
        return QueryExecutionUtils.queryAll((SphereClient)this.syncOptions.getCtpClient(), (QueryDsl)customObjectQuery).thenApply(customObjects -> customObjects.stream().map(CustomObject::getValue).collect(Collectors.toList())).thenApply(HashSet::new);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<WaitingToBeResolvedTransitions>> save(@Nonnull WaitingToBeResolvedTransitions draft) {
        CustomObjectDraft customObjectDraft = CustomObjectDraft.ofUnversionedUpsert((String)CUSTOM_OBJECT_CONTAINER_KEY, (String)this.hash(draft.getStateDraft().getKey()), (Object)draft, WaitingToBeResolvedTransitions.class);
        return this.syncOptions.getCtpClient().execute((SphereRequest)CustomObjectUpsertCommand.of((CustomObjectDraft)customObjectDraft)).handle((resource, exception) -> {
            if (exception == null) {
                return Optional.of(resource.getValue());
            }
            this.syncOptions.applyErrorCallback(String.format(SAVE_FAILED, customObjectDraft.getKey(), draft.getStateDraft().getKey()), (Throwable)exception);
            return Optional.empty();
        });
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<WaitingToBeResolvedTransitions>> delete(@Nonnull String key) {
        return this.syncOptions.getCtpClient().execute((SphereRequest)CustomObjectDeleteCommand.of((String)CUSTOM_OBJECT_CONTAINER_KEY, (String)this.hash(key), WaitingToBeResolvedTransitions.class)).handle((resource, exception) -> {
            if (exception == null) {
                return Optional.of(resource.getValue());
            }
            this.syncOptions.applyErrorCallback(String.format(DELETE_FAILED, this.hash(key), key), (Throwable)exception);
            return Optional.empty();
        });
    }
}

