/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states;

import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.models.WaitingToBeResolvedTransitions;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.UnresolvedTransitionsService;
import com.commercetools.sync.services.impl.StateServiceImpl;
import com.commercetools.sync.services.impl.UnresolvedTransitionsServiceImpl;
import com.commercetools.sync.states.StateSyncOptions;
import com.commercetools.sync.states.helpers.StateBatchProcessor;
import com.commercetools.sync.states.helpers.StateReferenceResolver;
import com.commercetools.sync.states.helpers.StateSyncStatistics;
import com.commercetools.sync.states.utils.StateSyncUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.sphere.sdk.commands.UpdateAction;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class StateSync
extends BaseSync<StateDraft, StateSyncStatistics, StateSyncOptions> {
    private static final String CTP_STATE_FETCH_FAILED = "Failed to fetch existing states with keys: '%s'.";
    private static final String CTP_STATE_UPDATE_FAILED = "Failed to update state with key: '%s'. Reason: %s";
    private static final String FAILED_TO_PROCESS = "Failed to process the StateDraft with key: '%s'. Reason: %s";
    private static final String UNRESOLVED_TRANSITIONS_STORE_FETCH_FAILED = "Failed to fetch StateDrafts waiting to be resolved with keys '%s'.";
    private final StateService stateService;
    private final StateReferenceResolver stateReferenceResolver;
    private final UnresolvedTransitionsService unresolvedTransitionsService;
    private ConcurrentHashMap.KeySetView<String, Boolean> readyToResolve;

    public StateSync(@Nonnull StateSyncOptions stateSyncOptions) {
        this(stateSyncOptions, new StateServiceImpl(stateSyncOptions));
    }

    StateSync(@Nonnull StateSyncOptions stateSyncOptions, @Nonnull StateService stateService) {
        super(new StateSyncStatistics(), stateSyncOptions);
        this.stateService = stateService;
        this.stateReferenceResolver = new StateReferenceResolver((StateSyncOptions)this.syncOptions, stateService);
        this.unresolvedTransitionsService = new UnresolvedTransitionsServiceImpl(stateSyncOptions);
    }

    @Override
    protected CompletionStage<StateSyncStatistics> process(@Nonnull List<StateDraft> resourceDrafts) {
        List batches = SyncUtils.batchElements(resourceDrafts, ((StateSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture(this.statistics));
    }

    @Override
    protected CompletionStage<StateSyncStatistics> processBatch(@Nonnull List<StateDraft> batch) {
        this.readyToResolve = ConcurrentHashMap.newKeySet();
        StateBatchProcessor batchProcessor = new StateBatchProcessor(batch, this);
        batchProcessor.validateBatch();
        Set<StateDraft> validDrafts = batchProcessor.getValidDrafts();
        if (validDrafts.isEmpty()) {
            ((StateSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture(this.statistics);
        }
        Set<String> keysToCache = batchProcessor.getKeysToCache();
        return this.stateService.cacheKeysToIds(keysToCache).handle(ImmutablePair::new).thenCompose(cachingResponse -> {
            Map keyToIdCache = (Map)cachingResponse.getKey();
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of state keys to ids.", cachingException, batch.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.syncBatch(validDrafts, keyToIdCache);
        }).thenApply(ignored -> {
            ((StateSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (StateSyncStatistics)this.statistics;
        });
    }

    private void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, int failedTimes) {
        ((StateSyncOptions)this.syncOptions).applyErrorCallback(errorMessage, exception);
        ((StateSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> syncBatch(@Nonnull Set<StateDraft> stateDrafts, @Nonnull Map<String, String> keyToIdCache) {
        if (stateDrafts.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        Set<String> stateDraftKeys = stateDrafts.stream().map(StateDraft::getKey).collect(Collectors.toSet());
        return this.stateService.fetchMatchingStatesByKeysWithTransitions(stateDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Throwable fetchException = (Throwable)fetchResponse.getValue();
            if (fetchException != null) {
                String errorMessage = String.format(CTP_STATE_FETCH_FAILED, stateDraftKeys);
                this.handleError(errorMessage, fetchException, stateDraftKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            Set matchingStates = (Set)fetchResponse.getKey();
            return this.syncOrKeepTrack(stateDrafts, matchingStates, keyToIdCache).thenCompose(aVoid -> this.resolveNowReadyReferences(keyToIdCache));
        });
    }

    @Nonnull
    private CompletionStage<Void> syncOrKeepTrack(@Nonnull Set<StateDraft> newStates, @Nonnull Set<State> oldStates, @Nonnull Map<String, String> keyToIdCache) {
        return CompletableFuture.allOf((CompletableFuture[])newStates.stream().map(newDraft -> {
            Set<String> missingTransitionStateKeys = this.getMissingTransitionStateKeys((StateDraft)newDraft, keyToIdCache);
            if (!missingTransitionStateKeys.isEmpty()) {
                return this.keepTrackOfMissingTransitionStates((StateDraft)newDraft, missingTransitionStateKeys);
            }
            return this.syncDraft(oldStates, (StateDraft)newDraft);
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    private Set<String> getMissingTransitionStateKeys(@Nonnull StateDraft newState, @Nonnull Map<String, String> keyToIdCache) {
        if (newState.getTransitions() == null || newState.getTransitions().isEmpty()) {
            return Collections.emptySet();
        }
        return newState.getTransitions().stream().map(Reference::getId).filter(key -> !keyToIdCache.containsKey(key)).collect(Collectors.toSet());
    }

    private CompletionStage<Optional<WaitingToBeResolvedTransitions>> keepTrackOfMissingTransitionStates(@Nonnull StateDraft newState, @Nonnull Set<String> missingTransitionParentStateKeys) {
        missingTransitionParentStateKeys.forEach(missingParentKey -> ((StateSyncStatistics)this.statistics).addMissingDependency((String)missingParentKey, newState.getKey()));
        return this.unresolvedTransitionsService.save(new WaitingToBeResolvedTransitions(newState, missingTransitionParentStateKeys));
    }

    @Nonnull
    private CompletionStage<Void> syncDraft(@Nonnull Set<State> oldStates, @Nonnull StateDraft newStateDraft) {
        Map oldStateMap = oldStates.stream().collect(Collectors.toMap(State::getKey, Function.identity()));
        return this.stateReferenceResolver.resolveReferences(newStateDraft).thenCompose(resolvedDraft -> {
            State oldState = (State)oldStateMap.get(newStateDraft.getKey());
            return Optional.ofNullable(oldState).map(state -> this.buildActionsAndUpdate(oldState, (StateDraft)resolvedDraft)).orElseGet(() -> this.applyCallbackAndCreate((StateDraft)resolvedDraft));
        }).exceptionally(completionException -> {
            String errorMessage = String.format(FAILED_TO_PROCESS, newStateDraft.getKey(), completionException.getMessage());
            this.handleError(errorMessage, (Throwable)completionException, 1);
            return null;
        });
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> applyCallbackAndCreate(@Nonnull StateDraft stateDraft) {
        return ((StateSyncOptions)this.syncOptions).applyBeforeCreateCallBack(stateDraft).map(draft -> this.stateService.createState((StateDraft)draft).thenAccept(stateOptional -> {
            if (stateOptional.isPresent()) {
                this.readyToResolve.add(stateDraft.getKey());
                ((StateSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((StateSyncStatistics)this.statistics).incrementFailed();
            }
        })).orElse(CompletableFuture.completedFuture(null));
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> buildActionsAndUpdate(@Nonnull State oldState, @Nonnull StateDraft newState) {
        List updateActions = StateSyncUtils.buildActions(oldState, newState);
        List<UpdateAction<State>> updateActionsAfterCallback = ((StateSyncOptions)this.syncOptions).applyBeforeUpdateCallBack(updateActions, newState, oldState);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateState(oldState, newState, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Void> updateState(@Nonnull State oldState, @Nonnull StateDraft newState, @Nonnull List<UpdateAction<State>> updateActions) {
        return this.stateService.updateState(oldState, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Throwable sphereException = (Throwable)updateResponse.getValue();
            if (sphereException != null) {
                return StateSync.executeSupplierIfConcurrentModificationException(sphereException, () -> this.fetchAndUpdate(oldState, newState), () -> {
                    String errorMessage = String.format(CTP_STATE_UPDATE_FAILED, newState.getKey(), sphereException.getMessage());
                    this.handleError(errorMessage, sphereException, 1);
                    return CompletableFuture.completedFuture(null);
                });
            }
            ((StateSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private CompletionStage<Void> fetchAndUpdate(@Nonnull State oldState, @Nonnull StateDraft newState) {
        String key = oldState.getKey();
        return this.stateService.fetchState(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedStateOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_STATE_UPDATE_FAILED, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedStateOptional.map(fetchedState -> this.buildActionsAndUpdate((State)fetchedState, newState)).orElseGet(() -> {
                String errorMessage = String.format(CTP_STATE_UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    private CompletionStage<Void> resolveNowReadyReferences(@Nonnull Map<String, String> keyToIdCache) {
        Set<String> referencingDraftKeys = this.readyToResolve.stream().map(((StateSyncStatistics)this.statistics)::removeAndGetReferencingKeys).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        if (referencingDraftKeys.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        HashSet readyToSync = new HashSet();
        HashSet waitingDraftsToBeUpdated = new HashSet();
        return this.unresolvedTransitionsService.fetch(referencingDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set waitingDrafts = (Set)fetchResponse.getKey();
            Throwable fetchException = (Throwable)fetchResponse.getValue();
            if (fetchException != null) {
                String errorMessage = String.format(UNRESOLVED_TRANSITIONS_STORE_FETCH_FAILED, referencingDraftKeys);
                this.handleError(errorMessage, fetchException, referencingDraftKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            waitingDrafts.forEach(waitingDraft -> {
                Set<String> missingTransitionStateKeys = waitingDraft.getMissingTransitionStateKeys();
                missingTransitionStateKeys.removeAll(this.readyToResolve);
                if (missingTransitionStateKeys.isEmpty()) {
                    readyToSync.add(waitingDraft.getStateDraft());
                } else {
                    waitingDraftsToBeUpdated.add(waitingDraft);
                }
            });
            return ((CompletableFuture)this.updateWaitingDrafts(waitingDraftsToBeUpdated).thenCompose(aVoid -> this.syncBatch(readyToSync, keyToIdCache))).thenCompose(aVoid -> this.removeFromWaiting(readyToSync));
        });
    }

    @Nonnull
    private CompletableFuture<Void> updateWaitingDrafts(@Nonnull Set<WaitingToBeResolvedTransitions> waitingDraftsToBeUpdated) {
        return CompletableFuture.allOf((CompletableFuture[])waitingDraftsToBeUpdated.stream().map(this.unresolvedTransitionsService::save).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletableFuture<Void> removeFromWaiting(@Nonnull Set<StateDraft> drafts) {
        return CompletableFuture.allOf((CompletableFuture[])drafts.stream().map(StateDraft::getKey).map(this.unresolvedTransitionsService::delete).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }
}

