/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.helpers;

import com.commercetools.sync.commons.exceptions.InvalidReferenceException;
import com.commercetools.sync.commons.exceptions.InvalidStateDraftException;
import com.commercetools.sync.states.StateSync;
import com.commercetools.sync.states.StateSyncOptions;
import com.commercetools.sync.states.helpers.StateSyncStatistics;
import io.sphere.sdk.models.Reference;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class StateBatchProcessor {
    static final String STATE_DRAFT_KEY_NOT_SET = "StateDraft with name: %s doesn't have a key. Please make sure all states have keys.";
    static final String STATE_DRAFT_IS_NULL = "StateDraft is null.";
    static final String STATE_HAS_INVALID_REFERENCES = "StateDraft with key: '%s' has invalid state transitions";
    private final List<StateDraft> stateDrafts;
    private final StateSync stateSync;
    private final Set<StateDraft> validDrafts = new HashSet<StateDraft>();
    private final Set<String> keysToCache = new HashSet<String>();

    public StateBatchProcessor(@Nonnull List<StateDraft> stateDrafts, @Nonnull StateSync stateSync) {
        this.stateDrafts = stateDrafts;
        this.stateSync = stateSync;
    }

    public void validateBatch() {
        for (StateDraft stateDraft : this.stateDrafts) {
            if (stateDraft != null) {
                String stateDraftKey = stateDraft.getKey();
                if (StringUtils.isNotBlank((CharSequence)stateDraftKey)) {
                    try {
                        this.keysToCache.add(stateDraftKey);
                        Set<String> referencesStateKeys = StateBatchProcessor.getTransitionKeys(stateDraft);
                        this.keysToCache.addAll(referencesStateKeys);
                        this.validDrafts.add(stateDraft);
                    }
                    catch (InvalidStateDraftException exception) {
                        this.handleError(exception);
                    }
                    continue;
                }
                String errorMessage = String.format(STATE_DRAFT_KEY_NOT_SET, stateDraft.getName());
                this.handleError(new InvalidStateDraftException(errorMessage));
                continue;
            }
            this.handleError(new InvalidStateDraftException(STATE_DRAFT_IS_NULL));
        }
    }

    @Nonnull
    private static Set<String> getTransitionKeys(@Nonnull StateDraft stateDraft) throws InvalidStateDraftException {
        Set transitions = stateDraft.getTransitions();
        if (transitions == null || transitions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> referencedStateKeys = new HashSet<String>();
        ArrayList<Reference> invalidStates = new ArrayList<Reference>();
        for (Reference transition : transitions) {
            if (transition == null) continue;
            try {
                referencedStateKeys.add(StateBatchProcessor.getStateKey((Reference<State>)transition));
            }
            catch (InvalidReferenceException invalidReferenceException) {
                invalidStates.add(transition);
            }
        }
        if (!invalidStates.isEmpty()) {
            String errorMessage = String.format(STATE_HAS_INVALID_REFERENCES, stateDraft.getKey());
            throw new InvalidStateDraftException(errorMessage, new InvalidReferenceException("The value of the 'id' field of the Resource Identifier/Reference is blank (null/empty)."));
        }
        return referencedStateKeys;
    }

    @Nonnull
    private static String getStateKey(@Nonnull Reference<State> stateReference) throws InvalidReferenceException {
        String key = stateReference.getId();
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new InvalidReferenceException("The value of the 'id' field of the Resource Identifier/Reference is blank (null/empty).");
        }
        return key;
    }

    private void handleError(@Nonnull Throwable throwable) {
        ((StateSyncOptions)this.stateSync.getSyncOptions()).applyErrorCallback(throwable.getMessage(), throwable);
        ((StateSyncStatistics)this.stateSync.getStatistics()).incrementFailed();
    }

    public Set<StateDraft> getValidDrafts() {
        return this.validDrafts;
    }

    public Set<String> getKeysToCache() {
        return this.keysToCache;
    }
}

