/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.helpers;

import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.states.StateSyncOptions;
import io.sphere.sdk.models.ResourceIdentifier;
import io.sphere.sdk.states.State;
import io.sphere.sdk.states.StateDraft;
import io.sphere.sdk.states.StateDraftBuilder;
import io.sphere.sdk.utils.CompletableFutureUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class StateReferenceResolver
extends BaseReferenceResolver<StateDraft, StateSyncOptions> {
    private final StateService stateService;
    private static final String FAILED_TO_RESOLVE_REFERENCE = "Failed to resolve 'transition' reference on StateDraft with key:'%s'. Reason: %s";

    public StateReferenceResolver(@Nonnull StateSyncOptions options, @Nonnull StateService stateService) {
        super(options);
        this.stateService = stateService;
    }

    @Override
    @Nonnull
    public CompletionStage<StateDraft> resolveReferences(@Nonnull StateDraft stateDraft) {
        return this.resolveTransitionReferences(StateDraftBuilder.of((StateDraft)stateDraft)).thenApply(rec$ -> ((StateDraftBuilder)rec$).build());
    }

    @Nonnull
    private CompletionStage<StateDraftBuilder> resolveTransitionReferences(@Nonnull StateDraftBuilder draftBuilder) {
        Set stateResourceIdentifiers = draftBuilder.getTransitions();
        HashSet<String> stateKeys = new HashSet<String>();
        if (stateResourceIdentifiers != null) {
            for (ResourceIdentifier stateResourceIdentifier : stateResourceIdentifiers) {
                if (stateResourceIdentifier == null) continue;
                try {
                    String stateKey = StateReferenceResolver.getKeyFromResourceIdentifier(stateResourceIdentifier);
                    stateKeys.add(stateKey);
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, draftBuilder.getKey(), referenceResolutionException.getMessage())));
                }
            }
        }
        return this.fetchAndResolveStateTransitions(draftBuilder, stateKeys);
    }

    @Nonnull
    private CompletionStage<StateDraftBuilder> fetchAndResolveStateTransitions(@Nonnull StateDraftBuilder draftBuilder, @Nonnull Set<String> stateKeys) {
        return this.stateService.fetchMatchingStatesByKeysWithTransitions(stateKeys).thenApply(states -> states.stream().map(State::toReference).filter(Objects::nonNull).collect(Collectors.toSet())).thenApply(references -> {
            if (!references.isEmpty()) {
                draftBuilder.transitions(references);
            }
            return draftBuilder;
        });
    }
}

