/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.helpers;

import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import io.sphere.sdk.utils.SphereInternalUtils;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StateSyncStatistics
extends BaseSyncStatistics {
    private ConcurrentHashMap<String, Set<String>> stateKeysWithMissingParents = new ConcurrentHashMap();

    @Override
    public String getReportMessage() {
        this.reportMessage = String.format("Summary: %s state(s) were processed in total (%s created, %s updated, %s failed to sync and %s state(s) with missing transition(s)).", this.getProcessed(), this.getCreated(), this.getUpdated(), this.getFailed(), this.getNumberOfStatesWithMissingParents());
        return this.reportMessage;
    }

    public int getNumberOfStatesWithMissingParents() {
        return (int)this.stateKeysWithMissingParents.values().stream().flatMap(Collection::stream).distinct().count();
    }

    public void addMissingDependency(@Nonnull String parentKey, @Nonnull String childKey) {
        this.stateKeysWithMissingParents.merge(parentKey, SphereInternalUtils.asSet((Object[])new String[]{childKey}), (existingSet, newChildAsSet) -> {
            existingSet.addAll(newChildAsSet);
            return existingSet;
        });
    }

    @Nullable
    public Set<String> removeAndGetReferencingKeys(@Nonnull String key) {
        return this.stateKeysWithMissingParents.remove(key);
    }
}

