/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CollectionUtils;
import com.commercetools.sync.commons.utils.QuadConsumer;
import com.commercetools.sync.commons.utils.TriConsumer;
import com.commercetools.sync.commons.utils.TriFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BaseSyncOptions<ResourceT, ResourceDraftT, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> {
    private final ProjectApiRoot ctpClient;
    private final QuadConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>, List<ResourceUpdateActionT>> errorCallback;
    private final TriConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>> warningCallback;
    private final int batchSize;
    private final TriFunction<List<ResourceUpdateActionT>, ResourceDraftT, ResourceT, List<ResourceUpdateActionT>> beforeUpdateCallback;
    private final Function<ResourceDraftT, ResourceDraftT> beforeCreateCallback;
    private final long cacheSize;

    protected BaseSyncOptions(@Nonnull ProjectApiRoot ctpClient, @Nullable QuadConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>, List<ResourceUpdateActionT>> errorCallback, @Nullable TriConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>> warningCallback, int batchSize, @Nullable TriFunction<List<ResourceUpdateActionT>, ResourceDraftT, ResourceT, List<ResourceUpdateActionT>> beforeUpdateCallback, @Nullable Function<ResourceDraftT, ResourceDraftT> beforeCreateCallback, long cacheSize) {
        this.ctpClient = ctpClient;
        this.errorCallback = errorCallback;
        this.batchSize = batchSize;
        this.warningCallback = warningCallback;
        this.beforeUpdateCallback = beforeUpdateCallback;
        this.beforeCreateCallback = beforeCreateCallback;
        this.cacheSize = cacheSize;
    }

    public ProjectApiRoot getCtpClient() {
        return this.ctpClient;
    }

    @Nullable
    public QuadConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>, List<ResourceUpdateActionT>> getErrorCallback() {
        return this.errorCallback;
    }

    @Nullable
    public TriConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>> getWarningCallback() {
        return this.warningCallback;
    }

    public void applyWarningCallback(@Nonnull SyncException exception, @Nullable ResourceT oldResource, @Nullable ResourceDraftT newResourceDraft) {
        if (this.warningCallback != null) {
            this.warningCallback.accept(exception, Optional.ofNullable(newResourceDraft), Optional.ofNullable(oldResource));
        }
    }

    public void applyErrorCallback(@Nonnull SyncException exception, @Nullable ResourceT oldResource, @Nullable ResourceDraftT newResourceDraft, @Nullable List<ResourceUpdateActionT> updateActions) {
        if (this.errorCallback != null) {
            this.errorCallback.accept(exception, Optional.ofNullable(newResourceDraft), Optional.ofNullable(oldResource), updateActions);
        }
    }

    public void applyErrorCallback(@Nonnull SyncException syncException) {
        this.applyErrorCallback(syncException, null, null, null);
    }

    public void applyErrorCallback(@Nonnull String errorMessage) {
        this.applyErrorCallback(new SyncException(errorMessage), null, null, null);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    @Nullable
    public TriFunction<List<ResourceUpdateActionT>, ResourceDraftT, ResourceT, List<ResourceUpdateActionT>> getBeforeUpdateCallback() {
        return this.beforeUpdateCallback;
    }

    @Nullable
    public Function<ResourceDraftT, ResourceDraftT> getBeforeCreateCallback() {
        return this.beforeCreateCallback;
    }

    @Nonnull
    public List<ResourceUpdateActionT> applyBeforeUpdateCallback(@Nonnull List<ResourceUpdateActionT> updateActions, @Nonnull ResourceDraftT newResourceDraft, @Nonnull ResourceT oldResource) {
        return Optional.ofNullable(this.beforeUpdateCallback).filter(callback -> !updateActions.isEmpty()).map(filteredCallback -> CollectionUtils.emptyIfNull((List)filteredCallback.apply(updateActions, newResourceDraft, oldResource))).orElse(updateActions);
    }

    @Nonnull
    public Optional<ResourceDraftT> applyBeforeCreateCallback(@Nonnull ResourceDraftT newResourceDraft) {
        return Optional.ofNullable(this.beforeCreateCallback != null ? this.beforeCreateCallback.apply(newResourceDraft) : newResourceDraft);
    }
}

