/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.api.models.type.CustomFields;
import com.commercetools.api.models.type.CustomFieldsDraft;
import com.commercetools.api.models.type.FieldContainer;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.GenericCustomActionBuilder;
import com.commercetools.sync.commons.models.Custom;
import com.commercetools.sync.commons.models.CustomDraft;
import com.commercetools.sync.commons.utils.CustomValueConverter;
import com.commercetools.sync.commons.utils.GenericUpdateActionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomUpdateActionUtils {
    private static final String CUSTOM_TYPE_IDS_NOT_SET = "Custom type ids are not set for both the old and new %s.";
    private static final String CUSTOM_FIELDS_UPDATE_ACTIONS_BUILD_FAILED = "Failed to build custom fields update actions on the %s with id '%s'. Reason: %s";
    private static final String CUSTOM_TYPE_ID_IS_BLANK = "New resource's custom type id is blank (empty/null).";

    @Nonnull
    public static <CustomT extends Custom, CustomDraftT extends CustomDraft, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildPrimaryResourceCustomUpdateActions(@Nonnull CustomT oldResource, @Nonnull CustomDraftT newResource, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nonnull BaseSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(oldResource, newResource, customActionBuilder, null, Custom::getId, Custom::getTypeId, resource -> null, syncOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public static <ResourceDraftT, CustomT extends Custom, CustomDraftT extends CustomDraft, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildCustomUpdateActions(@Nullable ResourceDraftT newMainResourceDraft, @Nonnull CustomT oldResource, @Nonnull CustomDraftT newResourceDraft, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nullable Long variantId, @Nonnull Function<CustomT, String> resourceIdGetter, @Nonnull Function<CustomT, String> resourceTypeIdGetter, @Nonnull Function<CustomT, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) {
        CustomFields oldResourceCustomFields = oldResource.getCustom();
        CustomFieldsDraft newResourceCustomFields = newResourceDraft.getCustom();
        if (oldResourceCustomFields != null && newResourceCustomFields != null) {
            try {
                return CustomUpdateActionUtils.buildNonNullCustomFieldsUpdateActions(oldResourceCustomFields, newResourceCustomFields, oldResource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
            }
            catch (BuildUpdateActionException exception) {
                String errorMessage = String.format(CUSTOM_FIELDS_UPDATE_ACTIONS_BUILD_FAILED, resourceTypeIdGetter.apply(oldResource), resourceIdGetter.apply(oldResource), exception.getMessage());
                syncOptions.applyErrorCallback(new SyncException(errorMessage, exception), oldResource, newMainResourceDraft != null ? newMainResourceDraft : newResourceDraft, null);
                return Collections.emptyList();
            }
        } else {
            if (oldResourceCustomFields != null) return Collections.singletonList(customActionBuilder.buildRemoveCustomTypeAction(variantId, updateIdGetter.apply(oldResource)));
            if (newResourceCustomFields == null) return Collections.emptyList();
            String newCustomFieldsTypeId = newResourceCustomFields.getType().getId();
            if (StringUtils.isBlank((CharSequence)newCustomFieldsTypeId)) {
                String errorMessage = String.format(CUSTOM_FIELDS_UPDATE_ACTIONS_BUILD_FAILED, resourceTypeIdGetter.apply(oldResource), resourceIdGetter.apply(oldResource), CUSTOM_TYPE_ID_IS_BLANK);
                syncOptions.applyErrorCallback(new SyncException(errorMessage, null), oldResource, newMainResourceDraft != null ? newMainResourceDraft : newResourceDraft, null);
                return Collections.emptyList();
            } else {
                Map newCustomFieldsJsonMap = newResourceCustomFields.getFields().values();
                Optional<ResourceUpdateActionT> updateAction = GenericUpdateActionUtils.buildTypedSetCustomTypeUpdateAction(newCustomFieldsTypeId, newCustomFieldsJsonMap, oldResource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
                return updateAction.map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
        }
    }

    @Nonnull
    private static <CustomT extends Custom, CustomDraftT extends CustomDraft, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildCustomUpdateActions(@Nonnull CustomT oldResource, @Nonnull CustomDraftT newResourceDraft, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nullable Long variantId, @Nonnull Function<CustomT, String> resourceIdGetter, @Nonnull Function<CustomT, String> resourceTypeIdGetter, @Nonnull Function<CustomT, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(null, oldResource, newResourceDraft, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
    }

    @Nonnull
    static <CustomT extends Custom, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildNonNullCustomFieldsUpdateActions(@Nonnull CustomFields oldCustomFields, @Nonnull CustomFieldsDraft newCustomFields, @Nonnull CustomT resource, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nullable Long variantId, @Nonnull Function<CustomT, String> resourceIdGetter, @Nonnull Function<CustomT, String> resourceTypeIdGetter, @Nonnull Function<CustomT, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) throws BuildUpdateActionException {
        String oldCustomTypeId = oldCustomFields.getType().getId();
        Map oldCustomFieldsJsonMap = oldCustomFields.getFields().values();
        String newCustomTypeId = newCustomFields.getType().getId();
        FieldContainer fields = newCustomFields.getFields();
        Map newCustomFieldsJsonMap = Collections.emptyMap();
        if (fields != null) {
            newCustomFieldsJsonMap = fields.values();
        }
        if (Objects.equals(oldCustomTypeId, newCustomTypeId)) {
            if (StringUtils.isBlank((CharSequence)oldCustomTypeId)) {
                throw new BuildUpdateActionException(String.format(CUSTOM_TYPE_IDS_NOT_SET, resourceTypeIdGetter.apply(resource)));
            }
            if (newCustomFieldsJsonMap == null) {
                Optional<ResourceUpdateActionT> updateAction = GenericUpdateActionUtils.buildTypedSetCustomTypeUpdateAction(newCustomTypeId, null, resource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
                return updateAction.map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
            return CustomUpdateActionUtils.buildSetCustomFieldsUpdateActions(oldCustomFieldsJsonMap, newCustomFieldsJsonMap, resource, customActionBuilder, variantId, updateIdGetter);
        }
        Optional<ResourceUpdateActionT> updateAction = GenericUpdateActionUtils.buildTypedSetCustomTypeUpdateAction(newCustomTypeId, newCustomFieldsJsonMap, resource, customActionBuilder, variantId, resourceIdGetter, resourceTypeIdGetter, updateIdGetter, syncOptions);
        return updateAction.map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    @Nonnull
    static <CustomT extends Custom, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildSetCustomFieldsUpdateActions(@Nonnull Map<String, Object> oldCustomFields, @Nonnull Map<String, Object> newCustomFields, @Nonnull CustomT resource, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nullable Long variantId, @Nonnull Function<CustomT, String> updateIdGetter) {
        List<ResourceUpdateActionT> customFieldsUpdateActions = CustomUpdateActionUtils.buildNewOrModifiedCustomFieldsUpdateActions(oldCustomFields, newCustomFields, resource, customActionBuilder, variantId, updateIdGetter);
        List<ResourceUpdateActionT> removedCustomFieldsActions = CustomUpdateActionUtils.buildRemovedCustomFieldsUpdateActions(oldCustomFields, newCustomFields, resource, customActionBuilder, variantId, updateIdGetter);
        customFieldsUpdateActions.addAll(removedCustomFieldsActions);
        return customFieldsUpdateActions;
    }

    @Nonnull
    private static <CustomT extends Custom, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildNewOrModifiedCustomFieldsUpdateActions(@Nonnull Map<String, Object> oldCustomFields, @Nonnull Map<String, Object> newCustomFields, @Nonnull CustomT resource, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nullable Long variantId, @Nonnull Function<CustomT, String> updateIdGetter) {
        return newCustomFields.keySet().stream().filter(newCustomFieldName -> {
            JsonNode newCustomFieldValue = CustomValueConverter.convertCustomValueObjDataToJsonNode(newCustomFields.get(newCustomFieldName));
            JsonNode oldCustomFieldValue = CustomValueConverter.convertCustomValueObjDataToJsonNode(oldCustomFields.get(newCustomFieldName));
            return !CustomUpdateActionUtils.isNullJsonValue(newCustomFieldValue) && !Objects.equals(newCustomFieldValue, oldCustomFieldValue);
        }).map(newCustomFieldName -> customActionBuilder.buildSetCustomFieldAction(variantId, (String)updateIdGetter.apply(resource), (String)newCustomFieldName, newCustomFields.get(newCustomFieldName))).collect(Collectors.toList());
    }

    private static boolean isNullJsonValue(@Nullable JsonNode value) {
        return !Objects.nonNull(value) || value.isNull();
    }

    @Nonnull
    private static <CustomT extends Custom, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildRemovedCustomFieldsUpdateActions(@Nonnull Map<String, Object> oldCustomFields, @Nonnull Map<String, Object> newCustomFields, @Nonnull CustomT resource, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nullable Long variantId, @Nonnull Function<CustomT, String> updateIdGetter) {
        return oldCustomFields.keySet().stream().filter(oldCustomFieldsName -> {
            JsonNode newCustomFieldValue = CustomValueConverter.convertCustomValueObjDataToJsonNode(newCustomFields.get(oldCustomFieldsName));
            JsonNode oldCustomFieldValue = CustomValueConverter.convertCustomValueObjDataToJsonNode(oldCustomFields.get(oldCustomFieldsName));
            return CustomUpdateActionUtils.isNullJsonValue(newCustomFieldValue) && oldCustomFieldValue != newCustomFieldValue;
        }).map(oldCustomFieldsName -> customActionBuilder.buildSetCustomFieldAction(variantId, (String)updateIdGetter.apply(resource), (String)oldCustomFieldsName, null)).collect(Collectors.toList());
    }

    private CustomUpdateActionUtils() {
    }
}

