/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.helpers.GenericCustomActionBuilder;
import com.commercetools.sync.commons.models.Custom;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

final class GenericUpdateActionUtils {
    @Nonnull
    static <CustomT extends Custom, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> buildTypedSetCustomTypeUpdateAction(@Nullable String customTypeId, @Nullable Map<String, Object> customFieldsJsonMap, @Nonnull CustomT resource, @Nonnull GenericCustomActionBuilder<ResourceUpdateActionT> customActionBuilder, @Nullable Long variantId, @Nonnull Function<CustomT, String> resourceIdGetter, @Nonnull Function<CustomT, String> resourceTypeIdGetter, @Nonnull Function<CustomT, String> updateIdGetter, @Nonnull BaseSyncOptions syncOptions) {
        if (!StringUtils.isBlank((CharSequence)customTypeId)) {
            return Optional.of(customActionBuilder.buildSetCustomTypeAction(variantId, updateIdGetter.apply(resource), customTypeId, customFieldsJsonMap));
        }
        String errorMessage = String.format("Failed to build 'setCustomType' update action on the %s with id '%s'. Reason: New Custom Type id is blank (null/empty).", resourceTypeIdGetter.apply(resource), resourceIdGetter.apply(resource));
        syncOptions.applyErrorCallback(errorMessage);
        return Optional.empty();
    }

    private GenericUpdateActionUtils() {
    }
}

