/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.utils;

import com.commercetools.api.models.customer.Customer;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.api.models.customer.CustomerUpdateAction;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.customers.models.CustomerCustomTypeAdapter;
import com.commercetools.sync.customers.models.CustomerDraftCustomTypeAdapter;
import com.commercetools.sync.customers.utils.CustomerCustomActionBuilder;
import com.commercetools.sync.customers.utils.CustomerUpdateActionUtils;
import java.util.List;
import javax.annotation.Nonnull;

public final class CustomerSyncUtils {
    private static final CustomerCustomActionBuilder customerCustomActionBuilder = CustomerCustomActionBuilder.of();

    @Nonnull
    public static List<CustomerUpdateAction> buildActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer, @Nonnull CustomerSyncOptions syncOptions) {
        List<CustomerUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(CustomerUpdateActionUtils.buildChangeEmailUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetFirstNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetLastNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetMiddleNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetTitleUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetSalutationUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetCustomerGroupUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetCustomerNumberUpdateAction(oldCustomer, newCustomer, syncOptions), CustomerUpdateActionUtils.buildSetExternalIdUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetCompanyNameUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetDateOfBirthUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetVatIdUpdateAction(oldCustomer, newCustomer), CustomerUpdateActionUtils.buildSetLocaleUpdateAction(oldCustomer, newCustomer));
        List<CustomerUpdateAction> addressUpdateActions = CustomerUpdateActionUtils.buildAllAddressUpdateActions(oldCustomer, newCustomer);
        updateActions.addAll(addressUpdateActions);
        List<CustomerUpdateAction> customerCustomUpdateActions = CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(CustomerCustomTypeAdapter.of(oldCustomer), CustomerDraftCustomTypeAdapter.of(newCustomer), customerCustomActionBuilder, syncOptions);
        updateActions.addAll(customerCustomUpdateActions);
        List<CustomerUpdateAction> buildStoreUpdateActions = CustomerUpdateActionUtils.buildStoreUpdateActions(oldCustomer, newCustomer);
        updateActions.addAll(buildStoreUpdateActions);
        return updateActions;
    }

    private CustomerSyncUtils() {
    }
}

