/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories;

import com.commercetools.api.models.channel.ChannelResourceIdentifier;
import com.commercetools.api.models.channel.ChannelRoleEnum;
import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.api.models.inventory.InventoryEntryUpdateAction;
import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventoryBatchValidator;
import com.commercetools.sync.inventories.helpers.InventoryEntryIdentifier;
import com.commercetools.sync.inventories.helpers.InventoryReferenceResolver;
import com.commercetools.sync.inventories.helpers.InventorySyncStatistics;
import com.commercetools.sync.inventories.utils.InventorySyncUtils;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.InventoryService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.ChannelServiceImpl;
import com.commercetools.sync.services.impl.InventoryServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public final class InventorySync
extends BaseSync<InventoryEntry, InventoryEntryDraft, InventoryEntryUpdateAction, InventorySyncStatistics, InventorySyncOptions> {
    private static final String CTP_INVENTORY_FETCH_FAILED = "Failed to fetch existing inventory entries of SKUs %s.";
    private static final String CTP_INVENTORY_ENTRY_UPDATE_FAILED = "Failed to update inventory entry of SKU '%s' and supply channel id '%s'.";
    private static final String FAILED_TO_PROCESS = "Failed to process the InventoryEntryDraft with SKU:'%s'. Reason: %s";
    private final InventoryService inventoryService;
    private final InventoryReferenceResolver referenceResolver;
    private final InventoryBatchValidator batchValidator;

    public InventorySync(@Nonnull InventorySyncOptions syncOptions) {
        this(syncOptions, new InventoryServiceImpl(syncOptions), new ChannelServiceImpl(syncOptions, Collections.singleton(ChannelRoleEnum.INVENTORY_SUPPLY)), new TypeServiceImpl(syncOptions));
    }

    InventorySync(@Nonnull InventorySyncOptions syncOptions, @Nonnull InventoryService inventoryService, @Nonnull ChannelService channelService, @Nonnull TypeService typeService) {
        super(new InventorySyncStatistics(), syncOptions);
        this.inventoryService = inventoryService;
        this.referenceResolver = new InventoryReferenceResolver((InventorySyncOptions)this.getSyncOptions(), typeService, channelService);
        this.batchValidator = new InventoryBatchValidator((InventorySyncOptions)this.getSyncOptions(), (InventorySyncStatistics)this.getStatistics());
    }

    @Override
    @Nonnull
    protected CompletionStage<InventorySyncStatistics> process(@Nonnull List<InventoryEntryDraft> inventoryEntryDrafts) {
        List batches = SyncUtils.batchElements(inventoryEntryDrafts, ((InventorySyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture((InventorySyncStatistics)this.statistics));
    }

    @Override
    protected CompletionStage<InventorySyncStatistics> processBatch(@Nonnull List<InventoryEntryDraft> batch) {
        ImmutablePair<Set<InventoryEntryDraft>, InventoryBatchValidator.ReferencedKeys> result = this.batchValidator.validateAndCollectReferencedKeys(batch);
        Set validDrafts = (Set)result.getLeft();
        if (validDrafts.isEmpty()) {
            ((InventorySyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture((InventorySyncStatistics)this.statistics);
        }
        return ((CompletableFuture)((CompletableFuture)this.referenceResolver.populateKeyToIdCachesForReferencedKeys((InventoryBatchValidator.ReferencedKeys)result.getRight()).handle(ImmutablePair::new)).thenCompose(cachingResponse -> {
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of keys to ids.", cachingException, null, null, null, validDrafts.size());
                return CompletableFuture.completedFuture(null);
            }
            return this.resolveReferences(validDrafts).thenCompose(this::syncResolvedDrafts);
        })).thenApply(ignored -> {
            ((InventorySyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (InventorySyncStatistics)this.statistics;
        });
    }

    private CompletableFuture<Set<InventoryEntryDraft>> resolveReferences(@Nonnull Set<InventoryEntryDraft> inventoryEntryDrafts) {
        List collect = inventoryEntryDrafts.stream().map(this::resolveReferences).collect(Collectors.toList());
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(collect, Collectors.toSet());
    }

    private CompletionStage<InventoryEntryDraft> resolveReferences(@Nonnull InventoryEntryDraft newInventoryEntry) {
        return this.referenceResolver.resolveReferences(newInventoryEntry).exceptionally(completionException -> {
            this.handleFailedToProcessError(newInventoryEntry, (Throwable)completionException);
            return null;
        });
    }

    private void handleFailedToProcessError(@Nonnull InventoryEntryDraft newInventoryEntry, @Nonnull Throwable completionException) {
        String errorMessage = String.format(FAILED_TO_PROCESS, newInventoryEntry.getSku(), completionException.getMessage());
        this.handleError(errorMessage, completionException, null, null, null, 1);
    }

    private CompletionStage<Void> syncResolvedDrafts(@Nonnull Set<InventoryEntryDraft> resolvedDrafts) {
        Set<InventoryEntryIdentifier> identifiers = resolvedDrafts.stream().map(InventoryEntryIdentifier::of).collect(Collectors.toSet());
        return this.inventoryService.fetchInventoryEntriesByIdentifiers(identifiers).handle(ImmutablePair::new).thenCompose(fetchResponse -> this.processFetchedInventories(resolvedDrafts, identifiers, (ImmutablePair<Set<InventoryEntry>, Throwable>)fetchResponse));
    }

    private CompletionStage<Void> processFetchedInventories(@Nonnull Set<InventoryEntryDraft> resolvedDrafts, @Nonnull Set<InventoryEntryIdentifier> identifiers, @Nonnull ImmutablePair<Set<InventoryEntry>, Throwable> fetchResponse) {
        Set fetchedInventoryEntries = (Set)fetchResponse.getKey();
        Throwable exception = (Throwable)fetchResponse.getValue();
        if (exception != null) {
            String errorMessage = String.format(CTP_INVENTORY_FETCH_FAILED, identifiers);
            this.handleError(errorMessage, exception, null, null, null, identifiers.size());
            return CompletableFuture.completedFuture(null);
        }
        return this.syncBatch(fetchedInventoryEntries, resolvedDrafts);
    }

    private CompletionStage<Void> syncBatch(@Nonnull Set<InventoryEntry> oldInventories, @Nonnull Set<InventoryEntryDraft> inventoryEntryDrafts) {
        Map oldInventoryMap = oldInventories.stream().collect(Collectors.toMap(InventoryEntryIdentifier::of, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])inventoryEntryDrafts.stream().map(newInventoryEntry -> this.syncDraft(oldInventoryMap, (InventoryEntryDraft)newInventoryEntry)).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    private CompletionStage<Optional<InventoryEntry>> syncDraft(@Nonnull Map<InventoryEntryIdentifier, InventoryEntry> oldInventories, @Nonnull InventoryEntryDraft resolvedDraft) {
        InventoryEntry oldInventory = oldInventories.get(InventoryEntryIdentifier.of(resolvedDraft));
        return Optional.ofNullable(oldInventory).map(type -> this.buildActionsAndUpdate(oldInventory, resolvedDraft)).orElseGet(() -> this.applyCallbackAndCreate(resolvedDraft)).exceptionally(completionException -> {
            this.handleFailedToProcessError(resolvedDraft, (Throwable)completionException);
            return Optional.empty();
        });
    }

    private CompletionStage<Optional<InventoryEntry>> buildActionsAndUpdate(@Nonnull InventoryEntry entry, @Nonnull InventoryEntryDraft draft) {
        List<InventoryEntryUpdateAction> updateActions = InventorySyncUtils.buildActions(entry, draft, (InventorySyncOptions)this.syncOptions);
        List<InventoryEntryUpdateAction> beforeUpdateCallBackApplied = ((InventorySyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, draft, entry);
        if (!beforeUpdateCallBackApplied.isEmpty()) {
            return this.inventoryService.updateInventoryEntry(entry, beforeUpdateCallBackApplied).handle(ImmutablePair::new).thenCompose(updateResponse -> {
                InventoryEntry updatedInventoryEntry = (InventoryEntry)updateResponse.getKey();
                Throwable ctpException = (Throwable)updateResponse.getValue();
                if (ctpException != null) {
                    ChannelResourceIdentifier supplyChannel = draft.getSupplyChannel();
                    String errorMessage = String.format(CTP_INVENTORY_ENTRY_UPDATE_FAILED, draft.getSku(), supplyChannel != null ? supplyChannel.getId() : null);
                    this.handleError(errorMessage, ctpException, entry, draft, updateActions, 1);
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                ((InventorySyncStatistics)this.statistics).incrementUpdated();
                return CompletableFuture.completedFuture(Optional.of(updatedInventoryEntry));
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletionStage<Optional<InventoryEntry>> applyCallbackAndCreate(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        return ((InventorySyncOptions)this.syncOptions).applyBeforeCreateCallback(inventoryEntryDraft).map(draft -> this.inventoryService.createInventoryEntry((InventoryEntryDraft)draft).thenApply(inventoryEntryOptional -> {
            if (inventoryEntryOptional.isPresent()) {
                ((InventorySyncStatistics)this.statistics).incrementCreated();
            } else {
                ((InventorySyncStatistics)this.statistics).incrementFailed();
            }
            return inventoryEntryOptional;
        })).orElse(CompletableFuture.completedFuture(Optional.empty()));
    }
}

