/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.api.models.common.Asset;
import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.api.models.product.ProductAddAssetAction;
import com.commercetools.api.models.product.ProductChangeAssetOrderAction;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductRemoveAssetAction;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.helpers.AssetActionFactory;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.utils.ProductVariantAssetUpdateActionUtils;
import java.util.List;
import javax.annotation.Nonnull;

public final class ProductAssetActionFactory
extends AssetActionFactory<ProductUpdateAction, ProductDraft> {
    private Long variantId;
    private BaseSyncOptions syncOptions;

    public ProductAssetActionFactory(@Nonnull Long variantId, @Nonnull ProductSyncOptions syncOptions) {
        this.variantId = variantId;
        this.syncOptions = syncOptions;
    }

    @Override
    public List<ProductUpdateAction> buildAssetActions(@Nonnull ProductDraft newResource, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAssetDraft) {
        return ProductVariantAssetUpdateActionUtils.buildActions(newResource, this.variantId, oldAsset, newAssetDraft, (ProductSyncOptions)this.syncOptions);
    }

    @Override
    public ProductUpdateAction buildRemoveAssetAction(@Nonnull String assetKey) {
        return ProductRemoveAssetAction.builder().variantId(this.variantId).assetKey(assetKey).staged(Boolean.valueOf(true)).build();
    }

    @Override
    public ProductUpdateAction buildChangeAssetOrderAction(@Nonnull List<String> newAssetOrder) {
        return ProductChangeAssetOrderAction.builder().variantId(this.variantId).assetOrder(newAssetOrder).staged(Boolean.valueOf(true)).build();
    }

    @Override
    public ProductUpdateAction buildAddAssetAction(@Nonnull AssetDraft assetDraft, @Nonnull Integer position) {
        return ProductAddAssetAction.builder().variantId(this.variantId).asset(assetDraft).position(position).staged(Boolean.valueOf(true)).build();
    }
}

