/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.api.models.category.CategoryResourceIdentifier;
import com.commercetools.api.models.category.CategoryResourceIdentifierBuilder;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.product.CategoryOrderHints;
import com.commercetools.api.models.product.CategoryOrderHintsBuilder;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductDraftBuilder;
import com.commercetools.api.models.product.ProductVariantDraft;
import com.commercetools.api.models.product_type.ProductTypeResourceIdentifier;
import com.commercetools.api.models.product_type.ProductTypeResourceIdentifierBuilder;
import com.commercetools.api.models.state.StateResourceIdentifier;
import com.commercetools.api.models.state.StateResourceIdentifierBuilder;
import com.commercetools.api.models.tax_category.TaxCategoryResourceIdentifier;
import com.commercetools.api.models.tax_category.TaxCategoryResourceIdentifierBuilder;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.ProductBatchValidator;
import com.commercetools.sync.products.helpers.VariantReferenceResolver;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomObjectService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.TaxCategoryService;
import com.commercetools.sync.services.TypeService;
import com.spotify.futures.CompletableFutures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class ProductReferenceResolver
extends BaseReferenceResolver<ProductDraft, ProductSyncOptions> {
    private final ProductTypeService productTypeService;
    private final CategoryService categoryService;
    private final VariantReferenceResolver variantReferenceResolver;
    private final TaxCategoryService taxCategoryService;
    private final StateService stateService;
    private final TypeService typeService;
    private final ChannelService channelService;
    private final ProductService productService;
    private final CustomerGroupService customerGroupService;
    private final CustomObjectService customObjectService;
    private final CustomerService customerService;
    public static final String FAILED_TO_RESOLVE_REFERENCE = "Failed to resolve '%s' resource identifier on ProductDraft with key:'%s'. Reason: %s";
    public static final String PRODUCT_TYPE_DOES_NOT_EXIST = "Product type with key '%s' doesn't exist.";
    public static final String TAX_CATEGORY_DOES_NOT_EXIST = "TaxCategory with key '%s' doesn't exist.";
    public static final String CATEGORIES_DO_NOT_EXIST = "Categories with keys '%s' don't exist.";
    public static final String STATE_DOES_NOT_EXIST = "State with key '%s' doesn't exist.";

    public ProductReferenceResolver(@Nonnull ProductSyncOptions productSyncOptions, @Nonnull ProductTypeService productTypeService, @Nonnull CategoryService categoryService, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService, @Nonnull TaxCategoryService taxCategoryService, @Nonnull StateService stateService, @Nonnull ProductService productService, @Nonnull CustomObjectService customObjectService, @Nonnull CustomerService customerService) {
        super(productSyncOptions);
        this.productTypeService = productTypeService;
        this.categoryService = categoryService;
        this.taxCategoryService = taxCategoryService;
        this.stateService = stateService;
        this.typeService = typeService;
        this.channelService = channelService;
        this.productService = productService;
        this.customerGroupService = customerGroupService;
        this.customObjectService = customObjectService;
        this.customerService = customerService;
        this.variantReferenceResolver = new VariantReferenceResolver(productSyncOptions, typeService, channelService, customerGroupService, productService, productTypeService, categoryService, customObjectService, stateService, customerService);
    }

    @Override
    public CompletionStage<ProductDraft> resolveReferences(@Nonnull ProductDraft productDraft) {
        return this.resolveProductTypeReference(ProductDraftBuilder.of((ProductDraft)productDraft)).thenCompose(this::resolveCategoryReferences).thenCompose(this::resolveAllVariantsReferences).thenCompose(this::resolveTaxCategoryReference).thenCompose(this::resolveStateReference).thenApply(ProductDraftBuilder::build);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> resolveAllVariantsReferences(@Nonnull ProductDraftBuilder draftBuilder) {
        ProductVariantDraft masterVariantDraft = draftBuilder.getMasterVariant();
        return this.variantReferenceResolver.resolveReferences(masterVariantDraft).thenApply(arg_0 -> ((ProductDraftBuilder)draftBuilder).masterVariant(arg_0)).thenCompose(this::resolveVariantsReferences);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> resolveVariantsReferences(@Nonnull ProductDraftBuilder draftBuilder) {
        List productDraftVariants = draftBuilder.getVariants();
        if (productDraftVariants == null) {
            return CompletableFuture.completedFuture(draftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productDraftVariants, this.variantReferenceResolver::resolveReferences, Collectors.toList()).thenApply(arg_0 -> ((ProductDraftBuilder)draftBuilder).variants(arg_0));
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveProductTypeReference(@Nonnull ProductDraftBuilder draftBuilder) {
        ProductTypeResourceIdentifier productTypeReference = draftBuilder.getProductType();
        if (productTypeReference != null && StringUtils.isBlank((CharSequence)productTypeReference.getId())) {
            String productTypeKey;
            try {
                productTypeKey = ProductReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)productTypeReference);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "product-type", draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveProductTypeReference(draftBuilder, productTypeKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> fetchAndResolveProductTypeReference(@Nonnull ProductDraftBuilder draftBuilder, @Nonnull String productTypeKey) {
        return this.productTypeService.fetchCachedProductTypeId(productTypeKey).thenCompose(resolvedProductTypeIdOptional -> resolvedProductTypeIdOptional.map(resolvedProductTypeId -> CompletableFuture.completedFuture(draftBuilder.productType(ProductTypeResourceIdentifierBuilder.of().id(resolvedProductTypeId).build()))).orElseGet(() -> {
            String errorMessage = String.format(PRODUCT_TYPE_DOES_NOT_EXIST, productTypeKey);
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "product-type", draftBuilder.getKey(), errorMessage)));
        }));
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveCategoryReferences(@Nonnull ProductDraftBuilder draftBuilder) {
        List categoryResourceIdentifiers = draftBuilder.getCategories();
        if (categoryResourceIdentifiers == null) {
            return CompletableFuture.completedFuture(draftBuilder);
        }
        HashSet<String> categoryKeys = new HashSet<String>();
        ArrayList<CategoryResourceIdentifier> directCategoryResourceIdentifiers = new ArrayList<CategoryResourceIdentifier>();
        for (CategoryResourceIdentifier categoryResourceIdentifier : categoryResourceIdentifiers) {
            if (categoryResourceIdentifier != null && StringUtils.isBlank((CharSequence)categoryResourceIdentifier.getId())) {
                try {
                    String categoryKey = ProductReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)categoryResourceIdentifier);
                    categoryKeys.add(categoryKey);
                    continue;
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "category", draftBuilder.getKey(), referenceResolutionException.getMessage())));
                }
            }
            directCategoryResourceIdentifiers.add(categoryResourceIdentifier);
        }
        return this.fetchAndResolveCategoryReferences(draftBuilder, categoryKeys, directCategoryResourceIdentifiers);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> fetchAndResolveCategoryReferences(@Nonnull ProductDraftBuilder draftBuilder, @Nonnull Set<String> categoryKeys, @Nonnull List<CategoryResourceIdentifier> directCategoryReferences) {
        HashMap categoryOrderHintsMap = new HashMap();
        CategoryOrderHints categoryOrderHints = draftBuilder.getCategoryOrderHints();
        HashMap keyToCategory = new HashMap();
        return this.categoryService.fetchMatchingCategoriesByKeys(categoryKeys).thenApply(categories -> categories.stream().map(category -> {
            keyToCategory.put(category.getKey(), category);
            if (categoryOrderHints != null && categoryOrderHints.values() != null) {
                Optional.ofNullable((String)categoryOrderHints.values().get(category.getKey())).ifPresent(orderHintValue -> categoryOrderHintsMap.put(category.getId(), orderHintValue));
            }
            return CategoryResourceIdentifierBuilder.of().id(category.getId()).build();
        }).collect(Collectors.toList())).thenCompose(categoryReferences -> {
            String keysNotExists = categoryKeys.stream().filter(categoryKey -> !keyToCategory.containsKey(categoryKey)).collect(Collectors.joining(", "));
            if (!StringUtils.isBlank((CharSequence)keysNotExists)) {
                String errorMessage = String.format(CATEGORIES_DO_NOT_EXIST, keysNotExists);
                return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "category", draftBuilder.getKey(), errorMessage)));
            }
            categoryReferences.addAll(directCategoryReferences);
            return CompletableFuture.completedFuture(draftBuilder.categories(categoryReferences).categoryOrderHints(CategoryOrderHintsBuilder.of().values(categoryOrderHintsMap).build()));
        });
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveTaxCategoryReference(@Nonnull ProductDraftBuilder draftBuilder) {
        TaxCategoryResourceIdentifier taxCategoryResourceIdentifier = draftBuilder.getTaxCategory();
        if (taxCategoryResourceIdentifier != null && StringUtils.isBlank((CharSequence)taxCategoryResourceIdentifier.getId())) {
            String taxCategoryKey;
            try {
                taxCategoryKey = ProductReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)taxCategoryResourceIdentifier);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "tax-category", draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveTaxCategoryReference(draftBuilder, taxCategoryKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> fetchAndResolveTaxCategoryReference(@Nonnull ProductDraftBuilder draftBuilder, @Nonnull String taxCategoryKey) {
        return this.taxCategoryService.fetchCachedTaxCategoryId(taxCategoryKey).thenCompose(resolvedTaxCategoryIdOptional -> resolvedTaxCategoryIdOptional.map(resolvedTaxCategoryId -> CompletableFuture.completedFuture(draftBuilder.taxCategory(TaxCategoryResourceIdentifierBuilder.of().id(resolvedTaxCategoryId).build()))).orElseGet(() -> {
            String errorMessage = String.format(TAX_CATEGORY_DOES_NOT_EXIST, taxCategoryKey);
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "tax-category", draftBuilder.getKey(), errorMessage)));
        }));
    }

    @Nonnull
    public CompletionStage<ProductDraftBuilder> resolveStateReference(@Nonnull ProductDraftBuilder draftBuilder) {
        StateResourceIdentifier stateReference = draftBuilder.getState();
        if (stateReference != null && StringUtils.isBlank((CharSequence)stateReference.getId())) {
            String stateKey;
            try {
                stateKey = ProductReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)stateReference);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "state", draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveStateReference(draftBuilder, stateKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<ProductDraftBuilder> fetchAndResolveStateReference(@Nonnull ProductDraftBuilder draftBuilder, @Nonnull String stateKey) {
        return this.stateService.fetchCachedStateId(stateKey).thenCompose(resolvedStateIdOptional -> resolvedStateIdOptional.map(resolvedStateId -> CompletableFuture.completedFuture(draftBuilder.state(StateResourceIdentifierBuilder.of().id(resolvedStateId).build()))).orElseGet(() -> {
            String errorMessage = String.format(STATE_DOES_NOT_EXIST, stateKey);
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_REFERENCE, "state", draftBuilder.getKey(), errorMessage)));
        }));
    }

    @Nonnull
    public CompletableFuture<Map<String, String>> populateKeyToIdCachesForReferencedKeys(@Nonnull ProductBatchValidator.ReferencedKeys referencedKeys) {
        Set<CustomObjectCompositeIdentifier> customObjectCompositeIdentifiers;
        Set<String> customerGroupKeys;
        Set<String> stateKeys;
        Set<String> channelKeys;
        Set<String> typeKeys;
        Set<String> taxCategoryKeys;
        Set<String> categoryKeys;
        Set<String> productTypeKeys;
        ArrayList<CompletionStage<Map<String, String>>> futures = new ArrayList<CompletionStage<Map<String, String>>>();
        Set<String> productKeys = referencedKeys.getProductKeys();
        if (!productKeys.isEmpty()) {
            futures.add(this.productService.cacheKeysToIds(productKeys));
        }
        if (!(productTypeKeys = referencedKeys.getProductTypeKeys()).isEmpty()) {
            futures.add(this.productTypeService.cacheKeysToIds(productTypeKeys));
        }
        if (!(categoryKeys = referencedKeys.getCategoryKeys()).isEmpty()) {
            futures.add(this.categoryService.cacheKeysToIds(categoryKeys));
        }
        if (!(taxCategoryKeys = referencedKeys.getTaxCategoryKeys()).isEmpty()) {
            futures.add(this.taxCategoryService.cacheKeysToIds(taxCategoryKeys));
        }
        if (!(typeKeys = referencedKeys.getTypeKeys()).isEmpty()) {
            futures.add(this.typeService.cacheKeysToIds(typeKeys));
        }
        if (!(channelKeys = referencedKeys.getChannelKeys()).isEmpty()) {
            futures.add(this.channelService.cacheKeysToIds(typeKeys));
        }
        if (!(stateKeys = referencedKeys.getStateKeys()).isEmpty()) {
            futures.add(this.stateService.cacheKeysToIds(stateKeys));
        }
        if (!(customerGroupKeys = referencedKeys.getCustomerGroupKeys()).isEmpty()) {
            futures.add(this.customerGroupService.cacheKeysToIds(customerGroupKeys));
        }
        if (!(customObjectCompositeIdentifiers = referencedKeys.getCustomObjectCompositeIdentifiers()).isEmpty()) {
            futures.add(this.customObjectService.cacheKeysToIds(customObjectCompositeIdentifiers));
        }
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList()).thenCompose(ignored -> this.productService.cacheKeysToIds(Collections.emptySet()));
    }
}

