/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.templates.beforeupdatecallback;

import com.commercetools.api.models.common.LocalizedString;
import com.commercetools.api.models.common.LocalizedStringEntry;
import com.commercetools.api.models.product.ProductChangeNameAction;
import com.commercetools.api.models.product.ProductChangeNameActionBuilder;
import com.commercetools.api.models.product.ProductChangeSlugAction;
import com.commercetools.api.models.product.ProductChangeSlugActionBuilder;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductDraftBuilder;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductSetDescriptionAction;
import com.commercetools.api.models.product.ProductSetDescriptionActionBuilder;
import com.commercetools.api.models.product.ProductSetMetaDescriptionAction;
import com.commercetools.api.models.product.ProductSetMetaDescriptionActionBuilder;
import com.commercetools.api.models.product.ProductSetMetaKeywordsAction;
import com.commercetools.api.models.product.ProductSetMetaKeywordsActionBuilder;
import com.commercetools.api.models.product.ProductSetMetaTitleAction;
import com.commercetools.api.models.product.ProductSetMetaTitleActionBuilder;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.sync.commons.utils.OptionalUtils;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SyncSingleLocale {
    @Nonnull
    public static List<ProductUpdateAction> syncFrenchDataOnly(@Nonnull List<ProductUpdateAction> updateActions, @Nonnull ProductDraft newProductDraft, @Nonnull ProductProjection oldProduct) {
        List optionalActions = updateActions.stream().map(action -> SyncSingleLocale.filterSingleLocalization(action, newProductDraft, oldProduct, Locale.FRENCH)).collect(Collectors.toList());
        return OptionalUtils.filterEmptyOptionals(optionalActions);
    }

    @Nonnull
    private static Optional<ProductUpdateAction> filterSingleLocalization(@Nonnull ProductUpdateAction updateAction, @Nonnull ProductDraft newProductDraft, @Nonnull ProductProjection oldProduct, @Nonnull Locale locale) {
        if (updateAction instanceof ProductChangeNameAction) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getName, p -> oldProduct.getName(), updated -> ProductChangeNameActionBuilder.of().name(updated).build());
        }
        if (updateAction instanceof ProductSetDescriptionAction) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getDescription, ProductProjection::getDescription, updated -> ProductSetDescriptionActionBuilder.of().description(updated).build());
        }
        if (updateAction instanceof ProductChangeSlugAction) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getSlug, ProductProjection::getSlug, updated -> ProductChangeSlugActionBuilder.of().slug(updated).build());
        }
        if (updateAction instanceof ProductSetMetaTitleAction) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getMetaTitle, ProductProjection::getMetaTitle, updated -> ProductSetMetaTitleActionBuilder.of().metaTitle(updated).build());
        }
        if (updateAction instanceof ProductSetMetaDescriptionAction) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getMetaDescription, ProductProjection::getMetaDescription, updated -> ProductSetMetaDescriptionActionBuilder.of().metaDescription(updated).build());
        }
        if (updateAction instanceof ProductSetMetaKeywordsAction) {
            return SyncSingleLocale.filterLocalizedField(newProductDraft, oldProduct, locale, ProductDraft::getMetaKeywords, ProductProjection::getMetaKeywords, updated -> ProductSetMetaKeywordsActionBuilder.of().metaKeywords(updated).build());
        }
        return Optional.of(updateAction);
    }

    @Nonnull
    private static Optional<ProductUpdateAction> filterLocalizedField(@Nonnull ProductDraft newDraft, @Nonnull ProductProjection oldProduct, @Nonnull Locale locale, @Nonnull Function<ProductDraft, LocalizedString> newLocalizedFieldMapper, @Nonnull Function<ProductProjection, LocalizedString> oldLocalizedFieldMapper, @Nonnull Function<LocalizedString, ProductUpdateAction> updateActionMapper) {
        LocalizedString newLocalizedField = newLocalizedFieldMapper.apply(newDraft);
        LocalizedString oldLocalizedField = oldLocalizedFieldMapper.apply(oldProduct);
        if (oldLocalizedField != null && newLocalizedField != null) {
            String newLocaleValue = newLocalizedField.get(locale);
            String oldLocaleValue = oldLocalizedField.get(locale);
            LocalizedString withLocaleChange = Optional.ofNullable(oldLocaleValue).map(value -> LocalizedString.of(oldLocalizedField.stream().filter(localization -> !localization.getLocale().equals(locale)).collect(Collectors.toMap(LocalizedStringEntry::getLocale, LocalizedStringEntry::getValue)))).orElse(oldLocalizedField);
            return Optional.ofNullable(Optional.ofNullable(newLocaleValue).map(val -> (ProductUpdateAction)updateActionMapper.apply(withLocaleChange.plus(locale, val))).orElseGet(() -> (ProductUpdateAction)updateActionMapper.apply(withLocaleChange)));
        }
        if (oldLocalizedField != null) {
            return Optional.ofNullable(oldLocalizedField.get(locale)).map(localValue -> (ProductUpdateAction)updateActionMapper.apply(LocalizedString.empty()));
        }
        return Optional.ofNullable(newLocalizedField.get(locale)).map(newLocalValue -> (ProductUpdateAction)updateActionMapper.apply(LocalizedString.of((Locale)locale, (String)newLocalValue)));
    }

    @Nonnull
    public static ProductDraft filterFrenchLocales(@Nonnull ProductDraft productDraft) {
        return SyncSingleLocale.filterLocalizedStrings(productDraft, Locale.FRENCH);
    }

    @Nonnull
    private static ProductDraft filterLocalizedStrings(@Nonnull ProductDraft productDraft, @Nonnull Locale locale) {
        LocalizedString name = productDraft.getName();
        LocalizedString slug = productDraft.getSlug();
        LocalizedString description = productDraft.getDescription();
        LocalizedString metaDescription = productDraft.getMetaDescription();
        LocalizedString metaKeywords = productDraft.getMetaKeywords();
        LocalizedString metaTitle = productDraft.getMetaTitle();
        return ProductDraftBuilder.of((ProductDraft)productDraft).name(SyncSingleLocale.filterLocale(name, locale)).slug(SyncSingleLocale.filterLocale(slug, locale)).description(SyncSingleLocale.filterLocale(description, locale)).metaDescription(SyncSingleLocale.filterLocale(metaDescription, locale)).metaKeywords(SyncSingleLocale.filterLocale(metaKeywords, locale)).metaTitle(SyncSingleLocale.filterLocale(metaTitle, locale)).build();
    }

    @Nullable
    private static LocalizedString filterLocale(@Nullable LocalizedString localizedString, @Nonnull Locale locale) {
        return Optional.ofNullable(localizedString).map(lText -> lText.stream().filter(localizedStringEntry -> Objects.equals(localizedStringEntry.getLocale(), locale)).collect(Collectors.toMap(LocalizedStringEntry::getLocale, LocalizedStringEntry::getValue))).map(LocalizedString::of).orElse(null);
    }

    private SyncSingleLocale() {
    }
}

