/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.common.Money;
import com.commercetools.api.models.common.Price;
import com.commercetools.api.models.common.PriceDraft;
import com.commercetools.api.models.common.TypedMoney;
import com.commercetools.api.models.product.ProductChangePriceAction;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.api.models.type.ResourceTypeId;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.PriceCustomActionBuilder;
import com.commercetools.sync.products.models.PriceCustomTypeAdapter;
import com.commercetools.sync.products.models.PriceDraftCustomTypeAdapter;
import com.commercetools.sync.products.utils.PriceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ProductVariantPriceUpdateActionUtils {
    private static final String VARIANT_CHANGE_PRICE_EMPTY_VALUE = "Cannot unset 'value' field of price with id '%s'.";

    @Nonnull
    public static List<ProductUpdateAction> buildActions(@Nonnull ProductDraft newProduct, @Nonnull Long variantId, @Nonnull Price oldPrice, @Nonnull PriceDraft newPrice, @Nonnull ProductSyncOptions syncOptions) {
        ArrayList<ProductUpdateAction> updateActions = new ArrayList<ProductUpdateAction>();
        ProductVariantPriceUpdateActionUtils.buildChangePriceUpdateAction(oldPrice, newPrice, syncOptions).ifPresent(updateActions::add);
        updateActions.addAll(ProductVariantPriceUpdateActionUtils.buildCustomUpdateActions(newProduct, variantId, oldPrice, newPrice, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildChangePriceUpdateAction(@Nonnull Price oldPrice, @Nonnull PriceDraft newPrice, @Nonnull ProductSyncOptions syncOptions) {
        TypedMoney oldPriceValue = oldPrice.getValue();
        Money newPriceValue = newPrice.getValue();
        if (newPriceValue == null) {
            syncOptions.applyWarningCallback(new SyncException(String.format(VARIANT_CHANGE_PRICE_EMPTY_VALUE, oldPrice.getId())), null, null);
            return Optional.empty();
        }
        Optional<ProductUpdateAction> actionAfterValuesDiff = CommonTypeUpdateActionUtils.buildUpdateAction(oldPriceValue, newPriceValue, () -> ProductChangePriceAction.builder().priceId(oldPrice.getId()).price(newPrice).staged(Boolean.valueOf(true)).build());
        return actionAfterValuesDiff.map(Optional::of).orElseGet(() -> CommonTypeUpdateActionUtils.buildUpdateAction(PriceUtils.createPriceTierDraft(oldPrice.getTiers()), newPrice.getTiers(), () -> ProductChangePriceAction.builder().priceId(oldPrice.getId()).price(newPrice).staged(Boolean.valueOf(true)).build()));
    }

    @Nonnull
    public static List<ProductUpdateAction> buildCustomUpdateActions(@Nonnull ProductDraft newProduct, @Nonnull Long variantId, @Nonnull Price oldPrice, @Nonnull PriceDraft newPrice, @Nonnull ProductSyncOptions syncOptions) {
        PriceCustomTypeAdapter priceAdapter = PriceCustomTypeAdapter.of(oldPrice);
        PriceDraftCustomTypeAdapter priceDraftAdapter = PriceDraftCustomTypeAdapter.of(newPrice);
        List<ProductUpdateAction> customUpdateAction = CustomUpdateActionUtils.buildCustomUpdateActions(newProduct, priceAdapter, priceDraftAdapter, new PriceCustomActionBuilder(), variantId, PriceCustomTypeAdapter::getId, priceCustomTypeAdapter -> ResourceTypeId.PRODUCT_PRICE.getJsonName(), PriceCustomTypeAdapter::getId, syncOptions);
        ArrayList<ProductUpdateAction> productUpdateActions = new ArrayList<ProductUpdateAction>();
        customUpdateAction.forEach(resourceUpdateAction -> productUpdateActions.add((ProductUpdateAction)resourceUpdateAction));
        return productUpdateActions;
    }

    private ProductVariantPriceUpdateActionUtils() {
    }
}

