/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.common.PriceDraft;
import com.commercetools.api.models.product.ProductVariant;
import com.commercetools.api.models.product.ProductVariantDraft;
import com.commercetools.api.models.product.ProductVariantDraftBuilder;
import com.commercetools.sync.commons.utils.AssetReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.products.utils.PriceUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class VariantReferenceResolutionUtils {
    @Nonnull
    public static List<ProductVariantDraft> mapToProductVariantDrafts(@Nonnull List<ProductVariant> productVariants, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return productVariants.stream().filter(Objects::nonNull).map(variants -> VariantReferenceResolutionUtils.mapToProductVariantDraft(variants, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static ProductVariantDraft mapToProductVariantDraft(@Nonnull ProductVariant productVariant, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return ProductVariantDraftBuilder.of().sku(productVariant.getSku()).key(productVariant.getKey()).prices(VariantReferenceResolutionUtils.mapToPriceDrafts(productVariant, referenceIdToKeyCache)).attributes(productVariant.getAttributes()).assets(AssetReferenceResolutionUtils.mapToAssetDrafts(productVariant.getAssets(), referenceIdToKeyCache)).build();
    }

    @Nonnull
    static List<PriceDraft> mapToPriceDrafts(@Nonnull ProductVariant productVariant, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return PriceUtils.createPriceDraft(productVariant.getPrices(), referenceIdToKeyCache);
    }

    private VariantReferenceResolutionUtils() {
    }
}

