/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.product_type.AttributeDefinition;
import com.commercetools.api.models.product_type.AttributeNestedType;
import com.commercetools.api.models.product_type.AttributeSetType;
import com.commercetools.api.models.product_type.AttributeType;
import com.commercetools.api.models.product_type.ProductType;
import com.commercetools.api.models.product_type.ProductTypeDraft;
import com.commercetools.api.models.product_type.ProductTypeReference;
import com.commercetools.sync.commons.exceptions.ReferenceReplacementException;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.producttypes.utils.ProductTypeReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class ProductTypeTransformUtils {
    @Nonnull
    public static CompletableFuture<List<ProductTypeDraft>> toProductTypeDrafts(@Nonnull ProjectApiRoot client, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull List<ProductType> productTypes) {
        ProductTypeTransformServiceImpl productTypeTransformService = new ProductTypeTransformServiceImpl(client, referenceIdToKeyCache);
        return productTypeTransformService.toProductTypeDrafts(productTypes);
    }

    private static class ProductTypeTransformServiceImpl
    extends BaseTransformServiceImpl {
        public ProductTypeTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
            super(ctpClient, referenceIdToKeyCache);
        }

        @Nonnull
        public CompletableFuture<List<ProductTypeDraft>> toProductTypeDrafts(@Nonnull List<ProductType> productTypes) throws ReferenceReplacementException {
            return this.loadNestedProductTypeReferenceKeys(productTypes).thenApply(ignore -> ProductTypeReferenceResolutionUtils.mapToProductTypeDrafts(productTypes, this.referenceIdToKeyCache));
        }

        @Nonnull
        private CompletableFuture<Void> loadNestedProductTypeReferenceKeys(@Nonnull List<ProductType> productTypes) {
            HashSet<String> setOfTypeIds = new HashSet<String>(this.collectNestedReferenceIds(productTypes));
            return super.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResource.PRODUCT_TYPES);
        }

        private Set<String> collectNestedReferenceIds(@Nonnull List<ProductType> productTypes) {
            return productTypes.stream().map(productType -> productType.getAttributes().stream().filter(Objects::nonNull).map(AttributeDefinition::getType).map(this::getNestedAttributeId).filter(StringUtils::isNotBlank).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private String getNestedAttributeId(AttributeType attributeType) {
            if (attributeType instanceof AttributeNestedType) {
                ProductTypeReference nestedTypeReference = ((AttributeNestedType)attributeType).getTypeReference();
                return nestedTypeReference.getId();
            }
            if (attributeType instanceof AttributeSetType) {
                AttributeType elementType = ((AttributeSetType)attributeType).getElementType();
                return this.getNestedAttributeId(elementType);
            }
            return null;
        }
    }
}

