/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.graph_ql.GraphQLRequest;
import com.commercetools.api.models.graph_ql.GraphQLRequestBuilder;
import com.commercetools.api.models.graph_ql.GraphQLResponse;
import com.commercetools.api.models.graph_ql.GraphQLVariablesMapBuilder;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.commons.utils.CustomValueConverter;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public abstract class BaseTransformServiceImpl {
    public static final int CHUNK_SIZE = 300;
    public static final String KEY_IS_NOT_SET_PLACE_HOLDER = "KEY_IS_NOT_SET";
    protected final ReferenceIdToKeyCache referenceIdToKeyCache;
    private final ProjectApiRoot ctpClient;

    protected BaseTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        this.ctpClient = ctpClient;
        this.referenceIdToKeyCache = referenceIdToKeyCache;
    }

    protected ProjectApiRoot getCtpClient() {
        return this.ctpClient;
    }

    protected CompletableFuture<Void> fetchAndFillReferenceIdToKeyCache(@Nonnull Set<String> ids, @Nonnull GraphQlQueryResource requestType) {
        Set<String> nonCachedReferenceIds = this.getNonCachedReferenceIds(ids);
        if (nonCachedReferenceIds.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        List<List<String>> chunkedIds = ChunkUtils.chunk(nonCachedReferenceIds, 300);
        List<GraphQLRequest> graphQLRequests = this.createGraphQLRequests(chunkedIds, requestType);
        return ChunkUtils.executeChunks(this.getCtpClient(), graphQLRequests).thenAccept(graphQLResult -> this.cacheResourceReferenceKeys((List<ApiHttpResponse<GraphQLResponse>>)graphQLResult, requestType));
    }

    protected Map<GraphQlQueryResource, Set<String>> buildMapOfRequestTypeToReferencedIds(Set<JsonNode> references) {
        HashMap<GraphQlQueryResource, Set<String>> typedReferenceMap = new HashMap<GraphQlQueryResource, Set<String>>();
        typedReferenceMap.put(GraphQlQueryResource.CATEGORIES, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.CHANNELS, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.CUSTOMERS, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.CUSTOM_OBJECTS, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.CUSTOMER_GROUPS, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.PRODUCT_TYPES, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.PRODUCTS, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.SHOPPING_LISTS, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.STATES, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.TAX_CATEGORIES, new HashSet());
        typedReferenceMap.put(GraphQlQueryResource.TYPES, new HashSet());
        references.forEach(ref -> {
            String refAsText = ref.get("id").asText();
            switch (ref.get("typeId").asText()) {
                case "product": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.PRODUCTS)).add(refAsText);
                    break;
                }
                case "category": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.CATEGORIES)).add(refAsText);
                    break;
                }
                case "channel": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.CHANNELS)).add(refAsText);
                    break;
                }
                case "customer": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.CUSTOMERS)).add(refAsText);
                    break;
                }
                case "key-value-document": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.CUSTOM_OBJECTS)).add(refAsText);
                    break;
                }
                case "customer-group": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.CUSTOMER_GROUPS)).add(refAsText);
                    break;
                }
                case "product-type": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.PRODUCT_TYPES)).add(refAsText);
                    break;
                }
                case "shopping-list": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.SHOPPING_LISTS)).add(refAsText);
                    break;
                }
                case "state": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.STATES)).add(refAsText);
                    break;
                }
                case "tax-category": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.TAX_CATEGORIES)).add(refAsText);
                    break;
                }
                case "type": {
                    ((Set)typedReferenceMap.get((Object)GraphQlQueryResource.TYPES)).add(refAsText);
                    break;
                }
            }
        });
        return typedReferenceMap;
    }

    @Nonnull
    protected Set<String> getNonCachedReferenceIds(@Nonnull Set<String> referenceIds) {
        return referenceIds.stream().filter(id -> this.filterNonCachedIds((String)id)).collect(Collectors.toSet());
    }

    @Nonnull
    protected Set<JsonNode> getNonCachedReferences(@Nonnull List<JsonNode> references) {
        return references.stream().filter(ref -> this.filterNonCachedIds(ref.get("id").asText())).collect(Collectors.toSet());
    }

    private boolean filterNonCachedIds(@Nonnull String id) {
        return !this.referenceIdToKeyCache.containsKey(id) || KEY_IS_NOT_SET_PLACE_HOLDER.equals(this.referenceIdToKeyCache.get(id));
    }

    @Nonnull
    protected List<GraphQLRequest> createGraphQLRequests(@Nonnull List<List<String>> chunkedIds, @Nonnull GraphQlQueryResource requestType) {
        String query = "query fetchKeyToIdPairs($where: String, $limit: Int) {\n  " + requestType.getName() + "(limit: $limit, where: $where) {\n    results {\n      id\n      key\n    }\n  }\n}";
        List<GraphQLRequest> graphQLRequests = chunkedIds.stream().map(keys -> keys.stream().filter(id -> !StringUtils.isBlank((CharSequence)id)).map(StringEscapeUtils::escapeJava).map(s -> "\"" + s + "\"").collect(Collectors.joining(", "))).map(commaSeparatedIds -> String.format("id in (%s)", commaSeparatedIds)).map(whereQuery -> GraphQLVariablesMapBuilder.of().addValue("where", whereQuery).addValue("limit", (Object)300).build()).map(variables -> GraphQLRequestBuilder.of().query(query).variables(variables).build()).collect(Collectors.toList());
        return graphQLRequests;
    }

    protected void cacheResourceReferenceKeys(@Nonnull List<ApiHttpResponse<GraphQLResponse>> graphQLResults) {
        GraphQlQueryResource[] queryResources = GraphQlQueryResource.values();
        for (int i = 0; i < queryResources.length; ++i) {
            this.cacheResourceReferenceKeys(graphQLResults, queryResources[i]);
        }
    }

    protected void cacheResourceReferenceKeys(@Nonnull List<ApiHttpResponse<GraphQLResponse>> graphQLResults, @Nonnull GraphQlQueryResource requestType) {
        graphQLResults.stream().map(ApiHttpResponse::getBody).filter(Objects::nonNull).map(GraphQLResponse::getData).filter(Objects::nonNull).forEach(data -> {
            String requestTypeName;
            ObjectMapper objectMapper = JsonUtils.getConfiguredObjectMapper();
            JsonNode jsonNode = (JsonNode)objectMapper.convertValue(data, JsonNode.class);
            if (jsonNode.get(requestTypeName = requestType.getName()) != null && jsonNode.get(requestTypeName).get("results") != null) {
                Iterator elements = jsonNode.get(requestTypeName).get("results").elements();
                while (elements.hasNext()) {
                    JsonNode idAndKey = (JsonNode)elements.next();
                    this.fillReferenceIdToKeyCache(idAndKey.get("id"), idAndKey.get("key"));
                }
            }
        });
    }

    private void fillReferenceIdToKeyCache(@Nullable JsonNode id, @Nullable JsonNode key) {
        if (CustomValueConverter.isValidTextNode(id)) {
            String idValue = id.asText();
            String keyValue = CustomValueConverter.isValidTextNode(key) ? key.asText() : KEY_IS_NOT_SET_PLACE_HOLDER;
            this.referenceIdToKeyCache.add(idValue, keyValue);
        }
    }
}

