/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyProductProjectionsGet;
import com.commercetools.api.client.ByProjectKeyProductProjectionsKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyProductsPost;
import com.commercetools.api.models.product.Product;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductMixin;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductProjectionPagedQueryResponse;
import com.commercetools.api.models.product.ProductProjectionType;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.api.models.product.ProductUpdateBuilder;
import com.commercetools.api.predicates.query.product.ProductProjectionQueryBuilderDsl;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductServiceImpl
extends BaseServiceWithKey<ProductSyncOptions, ProductProjection, ProductDraft, ByProjectKeyProductProjectionsGet, ProductProjectionPagedQueryResponse, ByProjectKeyProductProjectionsKeyByKeyGet, Product, ProductProjectionQueryBuilderDsl, ByProjectKeyProductsPost>
implements ProductService {
    public ProductServiceImpl(@Nonnull ProductSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> getIdFromCacheOrFetch(@Nullable String key) {
        if (key == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        String cachedId = (String)this.keyToIdCache.getIfPresent((Object)key);
        if ("SELF_REFERENCE_ID".equals(cachedId)) {
            return CompletableFuture.completedFuture(Optional.of("SELF_REFERENCE_ID"));
        }
        ByProjectKeyProductProjectionsGet query = ((ProductSyncOptions)this.syncOptions).getCtpClient().productProjections().get().withWhere((Object)"key = :key").withPredicateVar("key", (Object)key);
        return this.fetchCachedResourceId(key, resource -> resource.getKey(), query);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> productKeys) {
        return super.cacheKeysToIdsUsingGraphQl(productKeys, GraphQlQueryResource.PRODUCTS);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<ProductProjection>> fetchMatchingProductsByKeys(@Nonnull Set<String> productKeys) {
        return super.fetchMatchingResources(productKeys, ProductProjection::getKey, keysNotCached -> ((ProductSyncOptions)this.syncOptions).getCtpClient().productProjections().get().withStaged((Object)true).withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductProjection>> fetchProduct(@Nullable String key) {
        ByProjectKeyProductProjectionsKeyByKeyGet query = ((ProductSyncOptions)this.syncOptions).getCtpClient().productProjections().withKey(key).get();
        return super.fetchResource(key, query);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ProductProjection>> createProduct(@Nonnull ProductDraft productDraft) {
        return super.createResource(productDraft, ProductDraft::getKey, Product::getId, product -> ProductMixin.toProjection((Product)product, (ProductProjectionType)ProductProjectionType.STAGED), () -> ((ProductSyncOptions)this.syncOptions).getCtpClient().products().create(productDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<ProductProjection> updateProduct(@Nonnull ProductProjection productProjection, @Nonnull List<ProductUpdateAction> updateActions) {
        return this.updateProductAndMapToProductProjection(productProjection, updateActions);
    }

    @Nonnull
    private CompletionStage<ProductProjection> updateProductAndMapToProductProjection(@Nonnull ProductProjection productProjection, @Nonnull List<ProductUpdateAction> updateActions) {
        List<List<ProductUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<ProductProjection> resultStage = CompletableFuture.completedFuture(productProjection);
        for (List<ProductUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenCompose(updatedProduct -> ((ProductSyncOptions)this.syncOptions).getCtpClient().products().withId(updatedProduct.getId()).post(ProductUpdateBuilder.of().actions(batch).version(updatedProduct.getVersion()).build()).execute()).thenApply(ApiHttpResponse::getBody).thenApply(product -> ProductMixin.toProjection((Product)product, (ProductProjectionType)ProductProjectionType.STAGED));
        }
        return resultStage;
    }
}

