/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.models.custom_object.CustomObject;
import com.commercetools.api.models.custom_object.CustomObjectDraft;
import com.commercetools.api.models.custom_object.CustomObjectDraftBuilder;
import com.commercetools.api.models.custom_object.CustomObjectPagedQueryResponse;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.models.WaitingToBeResolved;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.services.UnresolvedReferencesService;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;

public class UnresolvedReferencesServiceImpl<WaitingToBeResolvedT extends WaitingToBeResolved>
implements UnresolvedReferencesService<WaitingToBeResolvedT> {
    private final BaseSyncOptions syncOptions;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String SAVE_FAILED = "Failed to save CustomObject with key: '%s' (hash of product key: '%s').";
    private static final String DELETE_FAILED = "Failed to delete CustomObject with key: '%s' (hash of product key: '%s').";
    public static final String CUSTOM_OBJECT_PRODUCT_CONTAINER_KEY = "commercetools-sync-java.UnresolvedReferencesService.productDrafts";
    public static final String CUSTOM_OBJECT_CATEGORY_CONTAINER_KEY = "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts";
    public static final String CUSTOM_OBJECT_TRANSITION_CONTAINER_KEY = "commercetools-sync-java.UnresolvedTransitionsService.stateDrafts";

    public UnresolvedReferencesServiceImpl(@Nonnull BaseSyncOptions baseSyncOptions) {
        this.syncOptions = baseSyncOptions;
    }

    @Nonnull
    private String hash(@Nullable String customObjectKey) {
        return DigestUtils.sha1Hex((String)customObjectKey);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<WaitingToBeResolvedT>> fetch(@Nonnull Set<String> keys, @Nonnull String containerKey, @Nonnull Class<WaitingToBeResolvedT> clazz) {
        if (keys.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        int CHUNK_SIZE = 250;
        Set hashedKeys = keys.stream().map(this::hash).collect(Collectors.toSet());
        List chunkedKeys = ChunkUtils.chunk(hashedKeys, 250);
        List chunkedRequests = chunkedKeys.stream().map(_keys -> this.syncOptions.getCtpClient().customObjects().withContainer(containerKey).get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)_keys)).collect(Collectors.toList());
        return ((CompletableFuture)ChunkUtils.executeChunks(chunkedRequests).thenApply(apiHttpResponses -> apiHttpResponses.stream().map(apiHttpResponse -> ((CustomObjectPagedQueryResponse)apiHttpResponse.getBody()).getResults()).flatMap(Collection::stream).collect(Collectors.toList()))).thenApply(customObjects -> customObjects.stream().map(customObject -> (WaitingToBeResolved)OBJECT_MAPPER.convertValue(customObject.getValue(), clazz)).collect(Collectors.toSet()));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<WaitingToBeResolvedT>> save(@Nonnull WaitingToBeResolvedT draft, @Nonnull String containerKey, @Nonnull Class<WaitingToBeResolvedT> clazz) {
        CustomObjectDraft customObjectDraft = CustomObjectDraftBuilder.of().container(containerKey).key(this.hash(draft.getKey())).value(draft).build();
        return this.syncOptions.getCtpClient().customObjects().post(customObjectDraft).execute().handle((resource, exception) -> {
            if (exception == null) {
                CustomObject customObject = (CustomObject)resource.getBody();
                return Optional.ofNullable(customObject).map(co -> (WaitingToBeResolved)OBJECT_MAPPER.convertValue(co.getValue(), clazz));
            }
            this.syncOptions.applyErrorCallback(new SyncException(String.format(SAVE_FAILED, customObjectDraft.getKey(), draft.getKey()), (Throwable)exception));
            return Optional.empty();
        });
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<WaitingToBeResolvedT>> delete(@Nonnull String key, @Nonnull String containerKey, @Nonnull Class<WaitingToBeResolvedT> clazz) {
        return this.syncOptions.getCtpClient().customObjects().withContainerAndKey(containerKey, this.hash(key)).delete().execute().handle((resource, exception) -> {
            if (exception == null) {
                return Optional.of((WaitingToBeResolved)OBJECT_MAPPER.convertValue(((CustomObject)resource.getBody()).getValue(), clazz));
            }
            this.syncOptions.applyErrorCallback(new SyncException(String.format(DELETE_FAILED, this.hash(key), key), (Throwable)exception));
            return Optional.empty();
        });
    }
}

