/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.helpers;

import com.commercetools.api.models.shopping_list.ShoppingListLineItemDraft;
import com.commercetools.api.models.shopping_list.ShoppingListLineItemDraftBuilder;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class LineItemReferenceResolver
extends CustomReferenceResolver<ShoppingListLineItemDraft, ShoppingListLineItemDraftBuilder, ShoppingListSyncOptions> {
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on LineItemDraft with SKU: '%s'.";

    public LineItemReferenceResolver(@Nonnull ShoppingListSyncOptions shoppingListSyncOptions, @Nonnull TypeService typeService) {
        super(shoppingListSyncOptions, typeService);
    }

    @Override
    @Nonnull
    public CompletionStage<ShoppingListLineItemDraft> resolveReferences(@Nonnull ShoppingListLineItemDraft lineItemDraft) {
        return this.resolveCustomTypeReference(ShoppingListLineItemDraftBuilder.of((ShoppingListLineItemDraft)lineItemDraft)).thenApply(ShoppingListLineItemDraftBuilder::build);
    }

    @Override
    @Nonnull
    protected CompletionStage<ShoppingListLineItemDraftBuilder> resolveCustomTypeReference(@Nonnull ShoppingListLineItemDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, ShoppingListLineItemDraftBuilder::getCustom, ShoppingListLineItemDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getSku()));
    }
}

