/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.helpers;

import com.commercetools.api.models.cart_discount.CartDiscountDraft;
import com.commercetools.sync.cartdiscounts.CartDiscountSyncOptions;
import com.commercetools.sync.cartdiscounts.helpers.CartDiscountSyncStatistics;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CartDiscountBatchValidator
extends BaseBatchValidator<CartDiscountDraft, CartDiscountSyncOptions, CartDiscountSyncStatistics> {
    static final String CART_DISCOUNT_DRAFT_KEY_NOT_SET = "CartDiscountDraft with name: %s doesn't have a key. Please make sure all cart discount drafts have keys.";
    static final String CART_DISCOUNT_DRAFT_IS_NULL = "CartDiscountDraft is null.";

    public CartDiscountBatchValidator(@Nonnull CartDiscountSyncOptions syncOptions, @Nonnull CartDiscountSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<CartDiscountDraft>, Set<String>> validateAndCollectReferencedKeys(@Nonnull List<CartDiscountDraft> cartDiscountDrafts) {
        HashSet typeKeys = new HashSet();
        Set validDrafts = cartDiscountDrafts.stream().filter(this::isValidCartDiscountDraft).peek(cartDiscountDraft -> this.collectReferencedKeyFromCustomFieldsDraft(cartDiscountDraft.getCustom(), typeKeys::add)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, typeKeys);
    }

    private boolean isValidCartDiscountDraft(@Nullable CartDiscountDraft cartDiscountDraft) {
        if (cartDiscountDraft == null) {
            this.handleError(CART_DISCOUNT_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)cartDiscountDraft.getKey())) {
            this.handleError(String.format(CART_DISCOUNT_DRAFT_KEY_NOT_SET, cartDiscountDraft.getName()));
        } else {
            return true;
        }
        return false;
    }
}

