/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.utils;

import com.commercetools.api.models.cart_discount.CartDiscount;
import com.commercetools.api.models.cart_discount.CartDiscountDraft;
import com.commercetools.api.models.cart_discount.CartDiscountUpdateAction;
import com.commercetools.sync.cartdiscounts.CartDiscountSyncOptions;
import com.commercetools.sync.cartdiscounts.helpers.CartDiscountCustomActionBuilder;
import com.commercetools.sync.cartdiscounts.models.CartDiscountCustomTypeAdapter;
import com.commercetools.sync.cartdiscounts.models.CartDiscountDraftCustomTypeAdapter;
import com.commercetools.sync.cartdiscounts.utils.CartDiscountUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import java.util.List;
import javax.annotation.Nonnull;

public final class CartDiscountSyncUtils {
    private static final CartDiscountCustomActionBuilder cartDiscountCustomActionBuilder = new CartDiscountCustomActionBuilder();

    @Nonnull
    public static List<CartDiscountUpdateAction> buildActions(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount, @Nonnull CartDiscountSyncOptions syncOptions) {
        List<CartDiscountUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(CartDiscountUpdateActionUtils.buildChangeValueUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildChangeCartPredicateUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildChangeTargetUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildChangeIsActiveUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildChangeNameUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildSetDescriptionUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildChangeSortOrderUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildChangeRequiresDiscountCodeUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildSetValidDatesUpdateAction(oldCartDiscount, newCartDiscount), CartDiscountUpdateActionUtils.buildChangeStackingModeUpdateAction(oldCartDiscount, newCartDiscount));
        List<CartDiscountUpdateAction> cartDiscountCustomUpdateActions = CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(CartDiscountCustomTypeAdapter.of(oldCartDiscount), CartDiscountDraftCustomTypeAdapter.of(newCartDiscount), cartDiscountCustomActionBuilder, syncOptions);
        updateActions.addAll(cartDiscountCustomUpdateActions);
        return updateActions;
    }

    private CartDiscountSyncUtils() {
    }
}

