/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories;

import com.commercetools.api.models.category.Category;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategoryUpdateAction;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategoryBatchValidator;
import com.commercetools.sync.categories.helpers.CategoryReferenceResolver;
import com.commercetools.sync.categories.helpers.CategorySyncStatistics;
import com.commercetools.sync.categories.utils.CategorySyncUtils;
import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.models.WaitingToBeResolvedCategories;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.UnresolvedReferencesService;
import com.commercetools.sync.services.impl.CategoryServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import com.commercetools.sync.services.impl.UnresolvedReferencesServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CategorySync
extends BaseSync<Category, CategoryDraft, CategoryUpdateAction, CategorySyncStatistics, CategorySyncOptions> {
    private static final String FAILED_TO_FETCH = "Failed to fetch existing categories with keys: '%s'. Reason: %s";
    private static final String FAILED_TO_PROCESS = "Failed to process the CategoryDraft with key: '%s'. Reason: %s";
    private static final String UPDATE_FAILED = "Failed to update Category with key: '%s'. Reason: %s";
    private static final String FAILED_TO_FETCH_WAITING_DRAFTS = "Failed to fetch CategoryDraft waiting to be resolved with parent keys: '%s'.";
    private final CategoryService categoryService;
    private final UnresolvedReferencesService<WaitingToBeResolvedCategories> unresolvedReferencesService;
    private final CategoryReferenceResolver referenceResolver;
    private final CategoryBatchValidator batchValidator;
    private ConcurrentHashMap.KeySetView<String, Boolean> readyToResolve;
    private ConcurrentHashMap<CategoryDraft, Category> categoryDraftsToUpdateSequentially;

    public CategorySync(@Nonnull CategorySyncOptions syncOptions) {
        this(syncOptions, new TypeServiceImpl(syncOptions), new CategoryServiceImpl(syncOptions), new UnresolvedReferencesServiceImpl<WaitingToBeResolvedCategories>(syncOptions));
    }

    CategorySync(@Nonnull CategorySyncOptions syncOptions, @Nonnull TypeService typeService, @Nonnull CategoryService categoryService, @Nonnull UnresolvedReferencesService<WaitingToBeResolvedCategories> unresolvedReferencesService) {
        super(new CategorySyncStatistics(), syncOptions);
        this.categoryService = categoryService;
        this.unresolvedReferencesService = unresolvedReferencesService;
        this.referenceResolver = new CategoryReferenceResolver((CategorySyncOptions)this.getSyncOptions(), typeService, categoryService);
        this.batchValidator = new CategoryBatchValidator((CategorySyncOptions)this.getSyncOptions(), (CategorySyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<CategorySyncStatistics> process(@Nonnull List<CategoryDraft> categoryDrafts) {
        List batches = SyncUtils.batchElements(categoryDrafts, ((CategorySyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture((CategorySyncStatistics)this.statistics));
    }

    @Override
    protected CompletionStage<CategorySyncStatistics> processBatch(@Nonnull List<CategoryDraft> categoryDrafts) {
        this.setBatchState();
        ImmutablePair<Set<CategoryDraft>, CategoryBatchValidator.ReferencedKeys> result = this.batchValidator.validateAndCollectReferencedKeys(categoryDrafts);
        Set validDrafts = (Set)result.getLeft();
        if (validDrafts.isEmpty()) {
            ((CategorySyncStatistics)this.statistics).incrementProcessed(categoryDrafts.size());
            return CompletableFuture.completedFuture((CategorySyncStatistics)this.statistics);
        }
        return ((CompletableFuture)((CompletableFuture)this.referenceResolver.populateKeyToIdCachesForReferencedKeys((CategoryBatchValidator.ReferencedKeys)result.getRight()).handle(ImmutablePair::new)).thenCompose(cachingResponse -> {
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of keys to ids.", cachingException, null, null, null, validDrafts.size());
                return CompletableFuture.completedFuture(null);
            }
            Map keyToIdCache = (Map)cachingResponse.getKey();
            return this.syncBatch(validDrafts, keyToIdCache);
        })).thenApply(ignoredResult -> {
            ((CategorySyncStatistics)this.statistics).incrementProcessed(categoryDrafts.size());
            return (CategorySyncStatistics)this.statistics;
        });
    }

    private void setBatchState() {
        this.readyToResolve = ConcurrentHashMap.newKeySet();
        this.categoryDraftsToUpdateSequentially = new ConcurrentHashMap();
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<CategoryDraft> categoryDrafts, @Nonnull Map<String, String> keyToIdCache) {
        Set<String> categoryDraftKeys = categoryDrafts.stream().map(CategoryDraft::getKey).collect(Collectors.toSet());
        return this.categoryService.fetchMatchingCategoriesByKeys(categoryDraftKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Throwable fetchException = (Throwable)fetchResponse.getValue();
            if (fetchException != null) {
                String errorMessage = String.format(FAILED_TO_FETCH, categoryDraftKeys, fetchException.getMessage());
                this.handleError(errorMessage, fetchException, null, null, null, categoryDraftKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            Set matchingCategories = (Set)fetchResponse.getKey();
            return this.syncOrKeepTrack(categoryDrafts, matchingCategories, keyToIdCache).thenCompose(aVoid -> this.updateCategoriesSequentially(this.categoryDraftsToUpdateSequentially)).thenCompose(aVoid -> this.resolveNowReadyReferences(keyToIdCache));
        });
    }

    @Nonnull
    private CompletionStage<Void> syncOrKeepTrack(@Nonnull Set<CategoryDraft> newCategories, @Nonnull Set<Category> oldCategories, @Nonnull Map<String, String> keyToIdCache) {
        return CompletableFuture.allOf((CompletableFuture[])newCategories.stream().map(newDraft -> {
            Optional<String> missingReferencedParentCategoryKey = this.getMissingReferencedParentCategoryKey((CategoryDraft)newDraft, keyToIdCache);
            if (missingReferencedParentCategoryKey.isPresent()) {
                return this.keepTrackOfMissingReference((CategoryDraft)newDraft, missingReferencedParentCategoryKey.get());
            }
            return this.syncDraft(oldCategories, (CategoryDraft)newDraft);
        }).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    private Optional<String> getMissingReferencedParentCategoryKey(@Nonnull CategoryDraft newCategory, @Nonnull Map<String, String> keyToIdCache) {
        String parentCategoryKey = Optional.ofNullable(newCategory.getParent()).map(ResourceIdentifier::getKey).orElse(null);
        if (StringUtils.isBlank((CharSequence)parentCategoryKey) || keyToIdCache.containsKey(parentCategoryKey)) {
            return Optional.empty();
        }
        return Optional.of(parentCategoryKey);
    }

    private CompletionStage<Optional<WaitingToBeResolvedCategories>> keepTrackOfMissingReference(@Nonnull CategoryDraft newCategory, @Nonnull String parentCategoryKey) {
        ((CategorySyncStatistics)this.statistics).addMissingDependency(parentCategoryKey, newCategory.getKey());
        return this.unresolvedReferencesService.save(new WaitingToBeResolvedCategories(newCategory, Collections.singleton(parentCategoryKey)), "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", WaitingToBeResolvedCategories.class);
    }

    @Nonnull
    private CompletionStage<Void> syncDraft(@Nonnull Set<Category> oldCategories, @Nonnull CategoryDraft newCategory) {
        Map oldCategoryMap = oldCategories.stream().collect(Collectors.toMap(Category::getKey, Function.identity()));
        return this.referenceResolver.resolveReferences(newCategory).thenCompose(resolvedDraft -> {
            Category oldCategory = (Category)oldCategoryMap.get(newCategory.getKey());
            if (oldCategory != null) {
                return this.fetchAndUpdate(oldCategory, (CategoryDraft)resolvedDraft);
            }
            return this.applyCallbackAndCreate((CategoryDraft)resolvedDraft);
        }).exceptionally(completionException -> {
            String errorMessage = String.format(FAILED_TO_PROCESS, newCategory.getKey(), completionException.getMessage());
            this.handleError(errorMessage, (Throwable)completionException, null, newCategory, null, 1);
            return null;
        });
    }

    @Nonnull
    private CompletionStage<Void> applyCallbackAndCreate(@Nonnull CategoryDraft categoryDraft) {
        return ((CategorySyncOptions)this.syncOptions).applyBeforeCreateCallback(categoryDraft).map(draft -> this.categoryService.createCategory((CategoryDraft)draft).thenAccept(categoryOptional -> {
            if (categoryOptional.isPresent()) {
                this.readyToResolve.add(categoryDraft.getKey());
                ((CategorySyncStatistics)this.statistics).incrementCreated();
            } else {
                ((CategorySyncStatistics)this.statistics).incrementFailed();
            }
        })).orElse(CompletableFuture.completedFuture(null));
    }

    @Nonnull
    private CompletionStage<Void> fetchAndUpdate(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        String key = oldCategory.getKey();
        return this.categoryService.fetchCategory(key).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Optional fetchedCategoryOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(FAILED_TO_FETCH, key, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, oldCategory, newCategory, null, 1);
                return CompletableFuture.completedFuture(null);
            }
            if (CategorySync.requiresChangeParentUpdateAction(oldCategory, newCategory)) {
                this.categoryDraftsToUpdateSequentially.putIfAbsent(newCategory, oldCategory);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedCategoryOptional.map(fetchedCategory -> this.buildUpdateActionsAndUpdate((Category)fetchedCategory, newCategory)).orElseGet(() -> {
                String errorMessage = String.format(UPDATE_FAILED, key, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, oldCategory, newCategory, null, 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    static boolean requiresChangeParentUpdateAction(@Nonnull Category category, @Nonnull CategoryDraft categoryDraft) {
        return !CommonTypeUpdateActionUtils.areResourceIdentifiersEqual(category.getParent(), categoryDraft.getParent());
    }

    private CompletionStage<Void> updateCategory(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull List<CategoryUpdateAction> updateActions) {
        String categoryKey = oldCategory.getKey();
        return this.categoryService.updateCategory(oldCategory, updateActions).handle(ImmutablePair::new).thenCompose(updateResponse -> {
            Throwable ctpException = (Throwable)updateResponse.getValue();
            if (ctpException != null) {
                return CategorySync.executeSupplierIfConcurrentModificationException(ctpException, () -> this.fetchAndUpdate(oldCategory, newCategory), () -> {
                    String errorMessage = String.format(UPDATE_FAILED, categoryKey, ctpException.getMessage());
                    this.handleError(errorMessage, ctpException, oldCategory, newCategory, updateActions, 1);
                    this.categoryDraftsToUpdateSequentially.remove(newCategory);
                    return CompletableFuture.completedFuture(null);
                });
            }
            this.categoryDraftsToUpdateSequentially.remove(newCategory);
            ((CategorySyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private CompletionStage<Void> resolveNowReadyReferences(@Nonnull Map<String, String> keyToIdCache) {
        Set<String> referencingDraftKeys = this.readyToResolve.stream().map(((CategorySyncStatistics)this.statistics)::getChildrenKeys).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        if (referencingDraftKeys.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        HashSet readyToSync = new HashSet();
        return this.unresolvedReferencesService.fetch(referencingDraftKeys, "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", WaitingToBeResolvedCategories.class).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
            Set waitingDrafts = (Set)fetchResponse.getKey();
            Throwable fetchException = (Throwable)fetchResponse.getValue();
            if (fetchException != null) {
                String errorMessage = String.format(FAILED_TO_FETCH_WAITING_DRAFTS, referencingDraftKeys);
                this.handleError(errorMessage, fetchException, null, null, null, referencingDraftKeys.size());
                return CompletableFuture.completedFuture(null);
            }
            waitingDrafts.forEach(waitingDraft -> {
                waitingDraft.getMissingReferencedCategoriesKeys().forEach(parentKey -> ((CategorySyncStatistics)this.statistics).removeChildCategoryKeyFromMissingParentsMap((String)parentKey, waitingDraft.getKey()));
                readyToSync.add(waitingDraft.getCategoryDraft());
            });
            return this.syncBatch(readyToSync, keyToIdCache).thenCompose(aVoid -> this.removeFromWaiting(readyToSync));
        });
    }

    @Nonnull
    private CompletableFuture<Void> removeFromWaiting(@Nonnull Set<CategoryDraft> drafts) {
        return CompletableFuture.allOf((CompletableFuture[])drafts.stream().map(CategoryDraft::getKey).map(key -> this.unresolvedReferencesService.delete((String)key, "commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", WaitingToBeResolvedCategories.class)).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    private CompletionStage<Void> buildUpdateActionsAndUpdate(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        List<CategoryUpdateAction> updateActions = CategorySyncUtils.buildActions(oldCategory, newCategory, (CategorySyncOptions)this.syncOptions);
        List<CategoryUpdateAction> beforeUpdateCallBackApplied = ((CategorySyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, newCategory, oldCategory);
        if (!beforeUpdateCallBackApplied.isEmpty()) {
            return this.updateCategory(oldCategory, newCategory, beforeUpdateCallBackApplied);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> updateCategoriesSequentially(@Nonnull Map<CategoryDraft, Category> matchingCategories) {
        matchingCategories.entrySet().stream().map(entry -> this.buildUpdateActionsAndUpdate((Category)entry.getValue(), (CategoryDraft)entry.getKey())).map(CompletionStage::toCompletableFuture).forEach(CompletableFuture::join);
        return CompletableFuture.completedFuture(null);
    }
}

