/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.helpers;

import com.commercetools.api.models.category.CategoryAddAssetActionBuilder;
import com.commercetools.api.models.category.CategoryChangeAssetOrderActionBuilder;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategoryRemoveAssetActionBuilder;
import com.commercetools.api.models.category.CategoryUpdateAction;
import com.commercetools.api.models.common.Asset;
import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.utils.CategoryAssetUpdateActionUtils;
import com.commercetools.sync.commons.helpers.AssetActionFactory;
import java.util.List;
import javax.annotation.Nonnull;

public final class CategoryAssetActionFactory
extends AssetActionFactory<CategoryUpdateAction, CategoryDraft> {
    public CategoryAssetActionFactory(@Nonnull CategorySyncOptions syncOptions) {
        this.syncOptions = syncOptions;
    }

    @Override
    public List<CategoryUpdateAction> buildAssetActions(@Nonnull CategoryDraft newResource, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAssetDraft) {
        return CategoryAssetUpdateActionUtils.buildActions(newResource, oldAsset, newAssetDraft, (CategorySyncOptions)this.syncOptions);
    }

    @Override
    public CategoryUpdateAction buildRemoveAssetAction(@Nonnull String assetKey) {
        return CategoryRemoveAssetActionBuilder.of().assetKey(assetKey).build();
    }

    @Override
    public CategoryUpdateAction buildChangeAssetOrderAction(@Nonnull List<String> newAssetOrder) {
        return CategoryChangeAssetOrderActionBuilder.of().assetOrder(newAssetOrder).build();
    }

    @Override
    public CategoryUpdateAction buildAddAssetAction(@Nonnull AssetDraft assetDraft, @Nonnull Integer position) {
        return CategoryAddAssetActionBuilder.of().asset(assetDraft).position(position).build();
    }
}

