/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.helpers;

import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategoryDraftBuilder;
import com.commercetools.api.models.category.CategoryResourceIdentifier;
import com.commercetools.api.models.category.CategoryResourceIdentifierBuilder;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategoryBatchValidator;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.AssetReferenceResolver;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.TypeService;
import io.vrap.rmf.base.client.utils.CompletableFutureUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CategoryReferenceResolver
extends CustomReferenceResolver<CategoryDraft, CategoryDraftBuilder, CategorySyncOptions> {
    private final AssetReferenceResolver assetReferenceResolver;
    private final CategoryService categoryService;
    private final TypeService typeService;
    static final String FAILED_TO_RESOLVE_PARENT = "Failed to resolve parent reference on CategoryDraft with key:'%s'. Reason: %s";
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on CategoryDraft with key:'%s'.";
    static final String PARENT_CATEGORY_DOES_NOT_EXIST = "Parent category with key '%s' doesn't exist.";

    public CategoryReferenceResolver(@Nonnull CategorySyncOptions options, @Nonnull TypeService typeService, @Nonnull CategoryService categoryService) {
        super(options, typeService);
        this.assetReferenceResolver = new AssetReferenceResolver(options, typeService);
        this.categoryService = categoryService;
        this.typeService = typeService;
    }

    @Override
    @Nonnull
    public CompletionStage<CategoryDraft> resolveReferences(@Nonnull CategoryDraft categoryDraft) {
        return this.resolveCustomTypeReference(CategoryDraftBuilder.of((CategoryDraft)categoryDraft)).thenCompose(this::resolveParentReference).thenCompose(this::resolveAssetsReferences).thenApply(CategoryDraftBuilder::build);
    }

    @Nonnull
    CompletionStage<CategoryDraftBuilder> resolveAssetsReferences(@Nonnull CategoryDraftBuilder categoryDraftBuilder) {
        List categoryDraftAssets = categoryDraftBuilder.getAssets();
        if (categoryDraftAssets == null) {
            return CompletableFuture.completedFuture(categoryDraftBuilder);
        }
        return com.commercetools.sync.commons.utils.CompletableFutureUtils.mapValuesToFutureOfCompletedValues(categoryDraftAssets, this.assetReferenceResolver::resolveReferences, Collectors.toList()).thenApply(arg_0 -> ((CategoryDraftBuilder)categoryDraftBuilder).assets(arg_0));
    }

    @Override
    @Nonnull
    protected CompletionStage<CategoryDraftBuilder> resolveCustomTypeReference(@Nonnull CategoryDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, CategoryDraftBuilder::getCustom, CategoryDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }

    @Nonnull
    CompletionStage<CategoryDraftBuilder> resolveParentReference(@Nonnull CategoryDraftBuilder draftBuilder) {
        CategoryResourceIdentifier parent = draftBuilder.getParent();
        if (parent != null && parent.getId() == null) {
            try {
                String parentCategoryKey = CategoryReferenceResolver.getParentCategoryKey(parent, draftBuilder.getKey());
                return this.fetchAndResolveParentReference(draftBuilder, parentCategoryKey);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
            }
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private static String getParentCategoryKey(@Nonnull CategoryResourceIdentifier parentCategoryResourceIdentifier, @Nullable String categoryKey) throws ReferenceResolutionException {
        try {
            return CategoryReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)parentCategoryResourceIdentifier);
        }
        catch (ReferenceResolutionException referenceResolutionException) {
            throw new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_PARENT, categoryKey, referenceResolutionException.getMessage()), referenceResolutionException);
        }
    }

    @Nonnull
    private CompletionStage<CategoryDraftBuilder> fetchAndResolveParentReference(@Nonnull CategoryDraftBuilder draftBuilder, @Nullable String parentCategoryKey) {
        if (StringUtils.isBlank((CharSequence)parentCategoryKey)) {
            return CompletableFuture.completedFuture(draftBuilder);
        }
        return this.categoryService.fetchCachedCategoryId(parentCategoryKey).thenCompose(resolvedParentIdOptional -> resolvedParentIdOptional.map(resolvedParentId -> CompletableFuture.completedFuture(draftBuilder.parent(CategoryResourceIdentifierBuilder.of().id(resolvedParentId).build()))).orElseGet(() -> {
            String errorMessage = String.format(FAILED_TO_RESOLVE_PARENT, draftBuilder.getKey(), String.format(PARENT_CATEGORY_DOES_NOT_EXIST, parentCategoryKey));
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(errorMessage));
        }));
    }

    @Nonnull
    public CompletableFuture<Map<String, String>> populateKeyToIdCachesForReferencedKeys(@Nonnull CategoryBatchValidator.ReferencedKeys referencedKeys) {
        ArrayList<CompletionStage<Map<String, String>>> futures = new ArrayList<CompletionStage<Map<String, String>>>();
        futures.add(this.categoryService.cacheKeysToIds(referencedKeys.getCategoryKeys()));
        Set<String> typeKeys = referencedKeys.getTypeKeys();
        if (!typeKeys.isEmpty()) {
            futures.add(this.typeService.cacheKeysToIds(typeKeys));
        }
        return com.commercetools.sync.commons.utils.CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList()).thenApply(maps -> (Map)maps.get(0));
    }
}

