/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.category.Category;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.common.Asset;
import com.commercetools.api.models.common.Reference;
import com.commercetools.sync.categories.utils.CategoryReferenceResolutionUtils;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class CategoryTransformUtils {
    @Nonnull
    public static CompletableFuture<List<CategoryDraft>> toCategoryDrafts(@Nonnull ProjectApiRoot client, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull List<Category> categories) {
        CategoryTransformServiceImpl categoryTransformService = new CategoryTransformServiceImpl(client, referenceIdToKeyCache);
        return categoryTransformService.toCategoryDrafts(categories);
    }

    private static class CategoryTransformServiceImpl
    extends BaseTransformServiceImpl {
        public CategoryTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
            super(ctpClient, referenceIdToKeyCache);
        }

        @Nonnull
        public CompletableFuture<List<CategoryDraft>> toCategoryDrafts(@Nonnull List<Category> categories) {
            categories.forEach(category -> this.fillReferenceIdToKeyCache(category.getId(), category.getKey()));
            ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
            transformReferencesToRunParallel.add(this.transformParentCategoryReference(categories));
            transformReferencesToRunParallel.add(this.transformCustomTypeReference(categories));
            return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> CategoryReferenceResolutionUtils.mapToCategoryDrafts(categories, this.referenceIdToKeyCache));
        }

        private void fillReferenceIdToKeyCache(String id, String key) {
            String keyValue = StringUtils.isBlank((CharSequence)key) ? "KEY_IS_NOT_SET" : key;
            this.referenceIdToKeyCache.add(id, keyValue);
        }

        @Nonnull
        private CompletableFuture<Void> transformParentCategoryReference(@Nonnull List<Category> categories) {
            Set<String> parentCategoryIds = categories.stream().map(Category::getParent).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
            return super.fetchAndFillReferenceIdToKeyCache(parentCategoryIds, GraphQlQueryResource.CATEGORIES);
        }

        @Nonnull
        private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<Category> categories) {
            HashSet<String> setOfTypeIds = new HashSet<String>();
            setOfTypeIds.addAll(categories.stream().map(Category::getCustom).filter(Objects::nonNull).map(customFields -> customFields.getType().getId()).collect(Collectors.toSet()));
            setOfTypeIds.addAll(categories.stream().map(Category::getAssets).map(assets -> assets.stream().filter(Objects::nonNull).map(Asset::getCustom).filter(Objects::nonNull).map(customFields -> customFields.getType().getId()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet()));
            return super.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResource.TYPES);
        }
    }
}

