/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.api.models.common.AssetDraftBuilder;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.TypeService;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class AssetReferenceResolver
extends CustomReferenceResolver<AssetDraft, AssetDraftBuilder, BaseSyncOptions> {
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on AssetDraft with key:'%s'.";

    public AssetReferenceResolver(@Nonnull BaseSyncOptions options, @Nonnull TypeService typeService) {
        super(options, typeService);
    }

    @Override
    @Nonnull
    public CompletionStage<AssetDraft> resolveReferences(@Nonnull AssetDraft assetDraft) {
        return this.resolveCustomTypeReference(AssetDraftBuilder.of((AssetDraft)assetDraft)).thenApply(AssetDraftBuilder::build);
    }

    @Override
    @Nonnull
    protected CompletionStage<AssetDraftBuilder> resolveCustomTypeReference(@Nonnull AssetDraftBuilder assetDraftBuilder) {
        return this.resolveCustomTypeReference(assetDraftBuilder, AssetDraftBuilder::getCustom, AssetDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, assetDraftBuilder.getKey()));
    }
}

