/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.type.CustomFieldsDraft;
import com.commercetools.api.models.type.CustomFieldsDraftBuilder;
import com.commercetools.api.models.type.FieldContainer;
import com.commercetools.api.models.type.TypeResourceIdentifier;
import com.commercetools.api.models.type.TypeResourceIdentifierBuilder;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.services.TypeService;
import io.vrap.rmf.base.client.Builder;
import io.vrap.rmf.base.client.Draft;
import io.vrap.rmf.base.client.utils.CompletableFutureUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class CustomReferenceResolver<ResourceDraftT extends Draft<ResourceDraftT>, BuilderT extends Builder<ResourceDraftT>, SyncOptionsT extends BaseSyncOptions>
extends BaseReferenceResolver<ResourceDraftT, SyncOptionsT> {
    public static final String TYPE_DOES_NOT_EXIST = "Type with key '%s' doesn't exist.";
    private final TypeService typeService;

    protected CustomReferenceResolver(@Nonnull SyncOptionsT options, @Nonnull TypeService typeService) {
        super(options);
        this.typeService = typeService;
    }

    protected abstract CompletionStage<BuilderT> resolveCustomTypeReference(@Nonnull BuilderT var1);

    @Nonnull
    protected CompletionStage<BuilderT> resolveCustomTypeReference(@Nonnull BuilderT draftBuilder, @Nonnull Function<BuilderT, CustomFieldsDraft> customGetter, @Nonnull BiFunction<BuilderT, CustomFieldsDraft, BuilderT> customSetter, @Nonnull String errorMessage) {
        TypeResourceIdentifier customType;
        CustomFieldsDraft custom = customGetter.apply(draftBuilder);
        if (custom != null && (customType = custom.getType()).getId() == null) {
            String customTypeKey;
            try {
                customTypeKey = this.getCustomTypeKey((ResourceIdentifier)customType, errorMessage);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)referenceResolutionException);
            }
            return this.fetchAndResolveTypeReference(draftBuilder, customSetter, custom.getFields(), customTypeKey, errorMessage);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    private String getCustomTypeKey(@Nonnull ResourceIdentifier customType, @Nonnull String referenceResolutionErrorMessage) throws ReferenceResolutionException {
        try {
            return CustomReferenceResolver.getKeyFromResourceIdentifier(customType);
        }
        catch (ReferenceResolutionException exception) {
            String errorMessage = String.format("%s Reason: %s", referenceResolutionErrorMessage, exception.getMessage());
            throw new ReferenceResolutionException(errorMessage, exception);
        }
    }

    @Nonnull
    private CompletionStage<BuilderT> fetchAndResolveTypeReference(@Nonnull BuilderT draftBuilder, @Nonnull BiFunction<BuilderT, CustomFieldsDraft, BuilderT> customSetter, @Nullable FieldContainer customFields, @Nonnull String typeKey, @Nonnull String referenceResolutionErrorMessage) {
        return this.typeService.fetchCachedTypeId(typeKey).thenCompose(resolvedTypeIdOptional -> resolvedTypeIdOptional.map(resolvedTypeId -> CompletableFuture.completedFuture((Builder)customSetter.apply(draftBuilder, CustomFieldsDraftBuilder.of().fields(customFields).type(TypeResourceIdentifierBuilder.of().id(resolvedTypeId).build()).build()))).orElseGet(() -> {
            String errorMessage = String.format("%s Reason: %s", referenceResolutionErrorMessage, String.format(TYPE_DOES_NOT_EXIST, typeKey));
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(errorMessage));
        }));
    }
}

