/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.common.Asset;
import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.api.models.common.AssetDraftBuilder;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class AssetReferenceResolutionUtils {
    @Nonnull
    public static List<AssetDraft> mapToAssetDrafts(@Nonnull List<Asset> assets, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return assets.stream().map(asset -> AssetDraftBuilder.of().custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(asset, referenceIdToKeyCache)).description(asset.getDescription()).name(asset.getName()).key(asset.getKey()).sources(asset.getSources()).tags(asset.getTags()).build()).collect(Collectors.toList());
    }

    private AssetReferenceResolutionUtils() {
    }
}

