/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.api.models.WithKey;
import com.commercetools.sync.commons.exceptions.DuplicateKeyException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.TriFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class EnumValuesUpdateActionUtils {
    @Nonnull
    public static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildActions(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nullable List<WithKeyT> newEnumValues, @Nullable BiFunction<String, List<String>, ResourceUpdateActionT> removeEnumCallback, @Nullable TriFunction<String, WithKeyT, WithKeyT, List<ResourceUpdateActionT>> matchingEnumCallback, @Nullable BiFunction<String, WithKeyT, ResourceUpdateActionT> addEnumCallback, @Nullable BiFunction<String, List<WithKeyT>, ResourceUpdateActionT> changeOrderEnumCallback, @Nullable BiFunction<String, List<String>, ResourceUpdateActionT> changeOrderWithKeysEnumCallback) {
        if (newEnumValues != null) {
            return EnumValuesUpdateActionUtils.buildUpdateActions(definitionName, oldEnumValues, newEnumValues, removeEnumCallback, matchingEnumCallback, addEnumCallback, changeOrderEnumCallback, changeOrderWithKeysEnumCallback);
        }
        if (removeEnumCallback != null) {
            return EnumValuesUpdateActionUtils.buildRemoveEnumValuesUpdateAction(definitionName, oldEnumValues, null, removeEnumCallback).map(Collections::singletonList).orElse(Collections.emptyList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    private static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildUpdateActions(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nullable BiFunction<String, List<String>, ResourceUpdateActionT> removeEnumValuesUpdateActionCallback, @Nullable TriFunction<String, WithKeyT, WithKeyT, List<ResourceUpdateActionT>> matchingEnumCallback, @Nullable BiFunction<String, WithKeyT, ResourceUpdateActionT> addEnumCallback, @Nullable BiFunction<String, List<WithKeyT>, ResourceUpdateActionT> changeOrderEnumCallback, @Nullable BiFunction<String, List<String>, ResourceUpdateActionT> changeOrderWithKeysEnumCallback) {
        Optional<ResourceUpdateActionT> removeEnumValuesUpdateAction = EnumValuesUpdateActionUtils.getRemoveEnumValuesUpdateAction(definitionName, oldEnumValues, newEnumValues, removeEnumValuesUpdateActionCallback);
        List<ResourceUpdateActionT> matchingEnumValuesUpdateActions = EnumValuesUpdateActionUtils.getMatchingEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, matchingEnumCallback);
        List<ResourceUpdateActionT> addEnumValuesUpdateActions = EnumValuesUpdateActionUtils.getAddEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, addEnumCallback);
        Optional<ResourceUpdateActionT> changeEnumValuesOrderUpdateAction = EnumValuesUpdateActionUtils.getChangeEnumValuesOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderEnumCallback);
        Optional<ResourceUpdateActionT> changeEnumValuesWithKeysOrderUpdateActions = EnumValuesUpdateActionUtils.getChangeEnumValuesWithKeysOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderWithKeysEnumCallback);
        return Stream.of(removeEnumValuesUpdateAction.map(Collections::singletonList).orElse(Collections.emptyList()), matchingEnumValuesUpdateActions, addEnumValuesUpdateActions, changeEnumValuesOrderUpdateAction.map(Collections::singletonList).orElse(Collections.emptyList()), changeEnumValuesWithKeysOrderUpdateActions.map(Collections::singletonList).orElse(Collections.emptyList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> getChangeEnumValuesWithKeysOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nullable BiFunction<String, List<String>, ResourceUpdateActionT> changeOrderWithKeysEnumCallback) {
        return changeOrderWithKeysEnumCallback == null ? Optional.empty() : EnumValuesUpdateActionUtils.buildChangeEnumValuesWithKeysOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderWithKeysEnumCallback);
    }

    @Nonnull
    private static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> getChangeEnumValuesOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nullable BiFunction<String, List<WithKeyT>, ResourceUpdateActionT> changeOrderEnumCallback) {
        return changeOrderEnumCallback == null ? Optional.empty() : EnumValuesUpdateActionUtils.buildChangeEnumValuesOrderUpdateAction(definitionName, oldEnumValues, newEnumValues, changeOrderEnumCallback);
    }

    @Nonnull
    private static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> getAddEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nullable BiFunction<String, WithKeyT, ResourceUpdateActionT> addEnumCallback) {
        return addEnumCallback == null ? Collections.emptyList() : EnumValuesUpdateActionUtils.buildAddEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, addEnumCallback);
    }

    @Nonnull
    private static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> getMatchingEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nullable TriFunction<String, WithKeyT, WithKeyT, List<ResourceUpdateActionT>> matchingEnumCallback) {
        return matchingEnumCallback == null ? Collections.emptyList() : EnumValuesUpdateActionUtils.buildMatchingEnumValuesUpdateActions(definitionName, oldEnumValues, newEnumValues, matchingEnumCallback);
    }

    @Nonnull
    private static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> getRemoveEnumValuesUpdateAction(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nullable BiFunction<String, List<String>, ResourceUpdateActionT> removeEnumValuesUpdateActionCallback) {
        return removeEnumValuesUpdateActionCallback == null ? Optional.empty() : EnumValuesUpdateActionUtils.buildRemoveEnumValuesUpdateAction(definitionName, oldEnumValues, newEnumValues, removeEnumValuesUpdateActionCallback);
    }

    @Nonnull
    static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> buildChangeEnumValuesOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nonnull BiFunction<String, List<WithKeyT>, ResourceUpdateActionT> changeOrderEnumCallback) {
        Pair<List<String>, List<String>> keysPair = EnumValuesUpdateActionUtils.getAllKeysAndNewKeysPair(oldEnumValues, newEnumValues);
        return CommonTypeUpdateActionUtils.buildUpdateAction((List)keysPair.getLeft(), (List)keysPair.getRight(), () -> (ResourceUpdateAction)changeOrderEnumCallback.apply(definitionName, newEnumValues));
    }

    @Nonnull
    private static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> buildChangeEnumValuesWithKeysOrderUpdateAction(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nonnull BiFunction<String, List<String>, ResourceUpdateActionT> changeOrderEnumCallback) {
        Pair<List<String>, List<String>> keysPair = EnumValuesUpdateActionUtils.getAllKeysAndNewKeysPair(oldEnumValues, newEnumValues);
        return CommonTypeUpdateActionUtils.buildUpdateAction((List)keysPair.getLeft(), (List)keysPair.getRight(), () -> (ResourceUpdateAction)changeOrderEnumCallback.apply(definitionName, (List)keysPair.getRight()));
    }

    @Nonnull
    private static <WithKeyT extends WithKey> Pair<List<String>, List<String>> getAllKeysAndNewKeysPair(@Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues) {
        List newKeys = newEnumValues.stream().map(WithKey::getKey).collect(Collectors.toList());
        List existingKeys = oldEnumValues.stream().map(WithKey::getKey).filter(newKeys::contains).collect(Collectors.toList());
        List notExistingKeys = newKeys.stream().filter(newKey -> !existingKeys.contains(newKey)).collect(Collectors.toList());
        List allKeys = Stream.concat(existingKeys.stream(), notExistingKeys.stream()).collect(Collectors.toList());
        return ImmutablePair.of(allKeys, newKeys);
    }

    @Nonnull
    static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildAddEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nonnull BiFunction<String, WithKeyT, ResourceUpdateActionT> addEnumCallback) {
        Map oldEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, oldEnumValues);
        Map<String, WithKeyT> newEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, newEnumValues);
        return newEnumValuesKeyMap.values().stream().filter(newEnumValue -> !oldEnumValuesKeyMap.containsKey(newEnumValue.getKey())).map(newEnumValue -> (ResourceUpdateAction)addEnumCallback.apply(definitionName, newEnumValue)).collect(Collectors.toList());
    }

    @Nonnull
    static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> buildRemoveEnumValuesUpdateAction(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nullable List<WithKeyT> newEnumValues, @Nonnull BiFunction<String, List<String>, ResourceUpdateActionT> removeEnumCallback) {
        Map newEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, Optional.ofNullable(newEnumValues).orElse(Collections.emptyList()));
        List keysToRemove = oldEnumValues.stream().map(WithKey::getKey).filter(oldEnumValueKey -> !newEnumValuesKeyMap.containsKey(oldEnumValueKey)).collect(Collectors.toList());
        return keysToRemove.isEmpty() ? Optional.empty() : Optional.of((ResourceUpdateAction)removeEnumCallback.apply(definitionName, keysToRemove));
    }

    @Nonnull
    static <WithKeyT extends WithKey, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildMatchingEnumValuesUpdateActions(@Nonnull String definitionName, @Nonnull List<WithKeyT> oldEnumValues, @Nonnull List<WithKeyT> newEnumValues, @Nonnull TriFunction<String, WithKeyT, WithKeyT, List<ResourceUpdateActionT>> matchingEnumCallback) {
        Map newEnumValuesKeyMap = EnumValuesUpdateActionUtils.getEnumValuesKeyMapWithKeyValidation(definitionName, newEnumValues);
        return oldEnumValues.stream().filter(oldEnumValue -> newEnumValuesKeyMap.containsKey(oldEnumValue.getKey())).map(oldEnumValue -> (List)matchingEnumCallback.apply(definitionName, oldEnumValue, (WithKey)newEnumValuesKeyMap.get(oldEnumValue.getKey()))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private static <WithKeyT extends WithKey> Map<String, WithKeyT> getEnumValuesKeyMapWithKeyValidation(@Nonnull String definitionName, @Nonnull List<WithKeyT> enumValues) {
        return enumValues.stream().collect(Collectors.toMap(WithKey::getKey, enumValue -> enumValue, (enumValueA, enumValueB) -> {
            throw new DuplicateKeyException(String.format("Enum Values have duplicated keys. Definition name: '%s', Duplicated enum value: '%s'. Enum Values are expected to be unique inside their definition.", definitionName, enumValueA.getKey()));
        }));
    }

    private EnumValuesUpdateActionUtils() {
    }
}

