/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.utils;

import com.commercetools.api.models.common.Address;
import com.commercetools.api.models.common.AddressDraftBuilder;
import com.commercetools.api.models.common.BaseAddress;
import com.commercetools.api.models.customer.Customer;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.api.models.customer.CustomerDraftBuilder;
import com.commercetools.api.models.customer_group.CustomerGroupReference;
import com.commercetools.api.models.customer_group.CustomerGroupResourceIdentifier;
import com.commercetools.api.models.customer_group.CustomerGroupResourceIdentifierBuilder;
import com.commercetools.api.models.store.StoreResourceIdentifier;
import com.commercetools.api.models.store.StoreResourceIdentifierBuilder;
import com.commercetools.api.models.type.CustomFields;
import com.commercetools.api.models.type.CustomFieldsDraft;
import com.commercetools.api.models.type.CustomFieldsDraftBuilder;
import com.commercetools.api.models.type.TypeResourceIdentifierBuilder;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomerReferenceResolutionUtils {
    @Nonnull
    public static List<CustomerDraft> mapToCustomerDrafts(@Nonnull List<Customer> customers, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return customers.stream().map(customer -> CustomerReferenceResolutionUtils.mapToCustomerDraft(customer, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static CustomerDraft mapToCustomerDraft(@Nonnull Customer customer, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return CustomerDraftBuilder.of().email(customer.getEmail()).password(customer.getPassword()).customerNumber(customer.getCustomerNumber()).key(customer.getKey()).firstName(customer.getFirstName()).lastName(customer.getLastName()).middleName(customer.getMiddleName()).title(customer.getTitle()).externalId(customer.getExternalId()).companyName(customer.getCompanyName()).customerGroup(CustomerReferenceResolutionUtils.mapToCustomerGroupResourceIdentifier(customer.getCustomerGroup(), referenceIdToKeyCache)).dateOfBirth(customer.getDateOfBirth()).isEmailVerified(customer.getIsEmailVerified()).vatId(customer.getVatId()).addresses(CustomerReferenceResolutionUtils.mapToAddressesDraft(customer.getAddresses())).defaultBillingAddress(CustomerReferenceResolutionUtils.getAddressIndex(customer.getAddresses(), customer.getDefaultBillingAddressId())).billingAddresses(CustomerReferenceResolutionUtils.getAddressIndexList(customer.getAddresses(), customer.getBillingAddressIds())).defaultShippingAddress(CustomerReferenceResolutionUtils.getAddressIndex(customer.getAddresses(), customer.getDefaultShippingAddressId())).shippingAddresses(CustomerReferenceResolutionUtils.getAddressIndexList(customer.getAddresses(), customer.getShippingAddressIds())).custom(CustomerReferenceResolutionUtils.mapToCustomFieldsDraft(customer.getCustom(), referenceIdToKeyCache)).locale(customer.getLocale()).salutation(customer.getSalutation()).stores(CustomerReferenceResolutionUtils.mapToStores(customer)).build();
    }

    private static CustomerGroupResourceIdentifier mapToCustomerGroupResourceIdentifier(@Nullable CustomerGroupReference reference, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (reference != null) {
            CustomerGroupResourceIdentifierBuilder builder = new CustomerGroupResourceIdentifierBuilder();
            String id = reference.getId();
            if (referenceIdToKeyCache.containsKey(id)) {
                builder.key(referenceIdToKeyCache.get(id));
            } else {
                builder.id(id);
            }
            return builder.build();
        }
        return null;
    }

    private static List<BaseAddress> mapToAddressesDraft(@Nonnull List<Address> addresses) {
        if (addresses.isEmpty()) {
            return Collections.emptyList();
        }
        return addresses.stream().map(address -> {
            AddressDraftBuilder builder = AddressDraftBuilder.of().id(address.getId()).key(address.getKey()).title(address.getTitle()).salutation(address.getSalutation()).firstName(address.getFirstName()).lastName(address.getLastName()).streetName(address.getStreetName()).streetNumber(address.getStreetNumber()).additionalAddressInfo(address.getAdditionalAddressInfo()).postalCode(address.getPostalCode()).city(address.getCity()).region(address.getRegion()).country(address.getCountry()).company(address.getCompany()).department(address.getDepartment()).building(address.getBuilding()).apartment(address.getApartment()).pOBox(address.getPOBox()).phone(address.getPhone()).mobile(address.getMobile()).email(address.getEmail()).fax(address.getFax()).externalId(address.getExternalId());
            if (address.getCustom() != null) {
                builder.custom(CustomFieldsDraftBuilder.of().fields(address.getCustom().getFields()).build());
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    @Nullable
    private static Integer getAddressIndex(@Nullable List<Address> allAddresses, @Nullable String addressId) {
        if (allAddresses == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)addressId)) {
            return null;
        }
        for (int i = 0; i < allAddresses.size(); ++i) {
            String id = allAddresses.get(i).getId();
            if (id == null || !id.equals(addressId)) continue;
            return i;
        }
        return null;
    }

    private static List<Integer> getAddressIndexList(@Nullable List<Address> allAddresses, @Nullable List<String> addressIds) {
        if (allAddresses == null || addressIds == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (String addressId : addressIds) {
            indexes.add(CustomerReferenceResolutionUtils.getAddressIndex(allAddresses, addressId));
        }
        return indexes;
    }

    @Nullable
    private static CustomFieldsDraft mapToCustomFieldsDraft(@Nullable CustomFields customFields, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        if (customFields != null) {
            String typeId = customFields.getType().getId();
            CustomFieldsDraftBuilder customFieldsDraftBuilder = CustomFieldsDraftBuilder.of();
            if (referenceIdToKeyCache.containsKey(typeId)) {
                customFieldsDraftBuilder.type(TypeResourceIdentifierBuilder.of().key(referenceIdToKeyCache.get(typeId)).build());
            } else {
                customFieldsDraftBuilder.type(TypeResourceIdentifierBuilder.of().id(typeId).build());
            }
            customFieldsDraftBuilder.fields(customFields.getFields());
            return customFieldsDraftBuilder.build();
        }
        return null;
    }

    private static List<StoreResourceIdentifier> mapToStores(@Nonnull Customer customer) {
        List storeReferences = customer.getStores();
        if (storeReferences != null) {
            return storeReferences.stream().map(storeKeyReference -> StoreResourceIdentifierBuilder.of().key(storeKeyReference.getKey()).build()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private CustomerReferenceResolutionUtils() {
    }
}

