/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customobjects.helpers;

import com.commercetools.api.models.custom_object.CustomObject;
import com.commercetools.api.models.custom_object.CustomObjectDraft;
import com.commercetools.api.models.custom_object.CustomObjectDraftBuilder;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class CustomObjectCompositeIdentifier {
    private final String key;
    private final String container;
    private static final String WRONG_FORMAT_ERROR_MESSAGE = "The custom object identifier value: \"%s\" does not have the correct format. The correct format must have a vertical bar \"|\" character between the container and key.";

    private CustomObjectCompositeIdentifier(@Nonnull String key, @Nonnull String container) {
        this.key = key;
        this.container = container;
    }

    @Nonnull
    public static CustomObjectCompositeIdentifier of(@Nonnull CustomObjectDraft customObjectDraft) {
        return new CustomObjectCompositeIdentifier(customObjectDraft.getKey(), customObjectDraft.getContainer());
    }

    @Nonnull
    public static CustomObjectCompositeIdentifier of(@Nonnull CustomObject customObject) {
        return new CustomObjectCompositeIdentifier(customObject.getKey(), customObject.getContainer());
    }

    @Nonnull
    public static CustomObjectCompositeIdentifier of(@Nonnull String key, @Nonnull String container) {
        return CustomObjectCompositeIdentifier.of(CustomObjectDraftBuilder.of().container(container).key(key).value((Object)"").build());
    }

    @Nonnull
    public static CustomObjectCompositeIdentifier of(@Nonnull String identifierAsString) {
        String[] containerAndKey = identifierAsString.split("\\|");
        if (containerAndKey.length == 2) {
            return CustomObjectCompositeIdentifier.of(containerAndKey[1], containerAndKey[0]);
        }
        throw new IllegalArgumentException(String.format(WRONG_FORMAT_ERROR_MESSAGE, identifierAsString));
    }

    public String getKey() {
        return this.key;
    }

    public String getContainer() {
        return this.container;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CustomObjectCompositeIdentifier)) {
            return false;
        }
        CustomObjectCompositeIdentifier that = (CustomObjectCompositeIdentifier)obj;
        return this.key.equals(that.key) && this.container.equals(that.container);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.container);
    }

    public String toString() {
        return String.format("%s|%s", this.container, this.key);
    }
}

