/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.helpers;

import com.commercetools.api.models.channel.ChannelReference;
import com.commercetools.api.models.channel.ChannelResourceIdentifier;
import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InventoryEntryIdentifier {
    private final String sku;
    private final String supplyChannelId;

    private InventoryEntryIdentifier(@Nonnull String sku, @Nullable String supplyChannelId) {
        this.sku = sku;
        this.supplyChannelId = supplyChannelId;
    }

    public static InventoryEntryIdentifier of(@Nonnull InventoryEntryDraft inventoryEntryDraft) {
        ChannelResourceIdentifier supplyChannelIdentifier = inventoryEntryDraft.getSupplyChannel();
        return new InventoryEntryIdentifier(inventoryEntryDraft.getSku(), supplyChannelIdentifier != null ? supplyChannelIdentifier.getId() : null);
    }

    public static InventoryEntryIdentifier of(@Nonnull InventoryEntry inventoryEntry) {
        ChannelReference supplyChannel = inventoryEntry.getSupplyChannel();
        return new InventoryEntryIdentifier(inventoryEntry.getSku(), supplyChannel != null ? supplyChannel.getId() : null);
    }

    public String getSku() {
        return this.sku;
    }

    public String getSupplyChannelId() {
        return this.supplyChannelId;
    }

    public String toString() {
        return String.format("{sku='%s', supplyChannelId='%s'}", this.sku, this.supplyChannelId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InventoryEntryIdentifier)) {
            return false;
        }
        InventoryEntryIdentifier that = (InventoryEntryIdentifier)other;
        return this.getSku().equals(that.getSku()) && Objects.equals(this.getSupplyChannelId(), that.getSupplyChannelId());
    }

    public int hashCode() {
        return Objects.hash(this.getSku(), this.getSupplyChannelId());
    }
}

