/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.helpers;

import com.commercetools.api.client.ByProjectKeyInventoryGet;
import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.sync.inventories.helpers.InventoryEntryIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public final class InventoryEntryQueryBuilder {
    private static final int MAX_QUERY_LENGTH = 10000;

    public static List<ByProjectKeyInventoryGet> buildQueries(@Nonnull ProjectApiRoot ctpClient, @Nonnull Set<InventoryEntryIdentifier> identifiers) {
        if (identifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ByProjectKeyInventoryGet> inventoryEntryQueries = new ArrayList<ByProjectKeyInventoryGet>();
        StringBuilder queryBuilder = new StringBuilder();
        int limit = 0;
        for (InventoryEntryIdentifier identifier : identifiers) {
            String predicate = InventoryEntryQueryBuilder.buildQueryPredicate(identifier);
            if (queryBuilder.length() + predicate.length() > 10000) {
                inventoryEntryQueries.add(InventoryEntryQueryBuilder.getInventoryEntryQuery(ctpClient, queryBuilder, limit));
                queryBuilder.setLength(0);
                limit = 0;
            }
            queryBuilder.append("(");
            queryBuilder.append(predicate);
            queryBuilder.append(") or ");
            ++limit;
        }
        inventoryEntryQueries.add(InventoryEntryQueryBuilder.getInventoryEntryQuery(ctpClient, queryBuilder, limit));
        return inventoryEntryQueries;
    }

    private static ByProjectKeyInventoryGet getInventoryEntryQuery(@Nonnull ProjectApiRoot ctpClient, @Nonnull StringBuilder queryBuilder, int limit) {
        String queryString = queryBuilder.substring(0, queryBuilder.length() - 4);
        return ctpClient.inventory().get().withWhere((Object)queryString).withLimit((Object)limit).withWithTotal((Object)false);
    }

    private static String buildQueryPredicate(@Nonnull InventoryEntryIdentifier identifier) {
        String whereQuery = "sku=\"" + identifier.getSku() + "\" and ";
        String supplyChannelId = identifier.getSupplyChannelId();
        whereQuery = supplyChannelId == null ? whereQuery + "supplyChannel is not defined" : whereQuery + "supplyChannel(id=\"" + supplyChannelId + "\")";
        return whereQuery;
    }

    private InventoryEntryQueryBuilder() {
    }
}

