/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.api.models.channel.ChannelResourceIdentifier;
import com.commercetools.api.models.channel.ChannelResourceIdentifierBuilder;
import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.api.models.inventory.InventoryEntryDraftBuilder;
import com.commercetools.api.models.type.CustomFieldsDraft;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class InventoryReferenceResolutionUtils {
    @Nonnull
    public static List<InventoryEntryDraft> mapToInventoryEntryDrafts(@Nonnull List<InventoryEntry> inventoryEntries, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return inventoryEntries.stream().map(inventoryEntry -> InventoryReferenceResolutionUtils.mapToInventoryEntryDraft(inventoryEntry, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static InventoryEntryDraft mapToInventoryEntryDraft(@Nonnull InventoryEntry inventoryEntry, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        ChannelResourceIdentifier channelResourceIdentifier = SyncUtils.getResourceIdentifierWithKey((Reference)inventoryEntry.getSupplyChannel(), referenceIdToKeyCache, (id, key) -> ChannelResourceIdentifierBuilder.of().key(key).id(id).build());
        CustomFieldsDraft customFieldsDraft = CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(inventoryEntry, referenceIdToKeyCache);
        return InventoryReferenceResolutionUtils.getInventoryEntryDraft(inventoryEntry, customFieldsDraft, channelResourceIdentifier);
    }

    private static InventoryEntryDraft getInventoryEntryDraft(@Nonnull InventoryEntry inventoryEntry, @Nullable CustomFieldsDraft mappedCustomFields, @Nullable ChannelResourceIdentifier channel) {
        if (inventoryEntry.getSku() != null && inventoryEntry.getQuantityOnStock() != null) {
            return InventoryEntryDraftBuilder.of().sku(inventoryEntry.getSku()).quantityOnStock(inventoryEntry.getQuantityOnStock()).expectedDelivery(inventoryEntry.getExpectedDelivery()).restockableInDays(inventoryEntry.getRestockableInDays()).key(inventoryEntry.getKey()).custom(mappedCustomFields).supplyChannel(channel).build();
        }
        return InventoryEntryDraft.of();
    }

    private InventoryReferenceResolutionUtils() {
    }
}

