/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.api.models.product.Attribute;
import com.commercetools.api.models.product.AttributeBuilder;
import com.commercetools.api.models.product.ProductVariantDraft;
import com.commercetools.api.models.product.ProductVariantDraftBuilder;
import com.commercetools.sync.commons.helpers.AssetReferenceResolver;
import com.commercetools.sync.commons.helpers.BaseReferenceResolver;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import com.commercetools.sync.commons.utils.ResourceIdentifierUtils;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.PriceReferenceResolver;
import com.commercetools.sync.products.utils.AttributeUtils;
import com.commercetools.sync.services.CategoryService;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.CustomObjectService;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.ProductService;
import com.commercetools.sync.services.ProductTypeService;
import com.commercetools.sync.services.StateService;
import com.commercetools.sync.services.TypeService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class VariantReferenceResolver
extends BaseReferenceResolver<ProductVariantDraft, ProductSyncOptions> {
    private final PriceReferenceResolver priceReferenceResolver;
    private final AssetReferenceResolver assetReferenceResolver;
    private final ProductService productService;
    private final ProductTypeService productTypeService;
    private final CategoryService categoryService;
    private final CustomObjectService customObjectService;
    private final StateService stateService;
    private final CustomerService customerService;

    public VariantReferenceResolver(@Nonnull ProductSyncOptions productSyncOptions, @Nonnull TypeService typeService, @Nonnull ChannelService channelService, @Nonnull CustomerGroupService customerGroupService, @Nonnull ProductService productService, @Nonnull ProductTypeService productTypeService, @Nonnull CategoryService categoryService, @Nonnull CustomObjectService customObjectService, @Nonnull StateService stateService, @Nonnull CustomerService customerService) {
        super(productSyncOptions);
        this.priceReferenceResolver = new PriceReferenceResolver(productSyncOptions, typeService, channelService, customerGroupService);
        this.assetReferenceResolver = new AssetReferenceResolver(productSyncOptions, typeService);
        this.productService = productService;
        this.categoryService = categoryService;
        this.productTypeService = productTypeService;
        this.customObjectService = customObjectService;
        this.stateService = stateService;
        this.customerService = customerService;
    }

    @Override
    public CompletionStage<ProductVariantDraft> resolveReferences(@Nonnull ProductVariantDraft productVariantDraft) {
        return this.resolvePricesReferences(ProductVariantDraftBuilder.of((ProductVariantDraft)productVariantDraft)).thenCompose(this::resolveAssetsReferences).thenCompose(this::resolveAttributesReferences).thenApply(ProductVariantDraftBuilder::build);
    }

    @Nonnull
    CompletionStage<ProductVariantDraftBuilder> resolveAssetsReferences(@Nonnull ProductVariantDraftBuilder productVariantDraftBuilder) {
        List productVariantDraftAssets = productVariantDraftBuilder.getAssets();
        if (productVariantDraftAssets == null) {
            return CompletableFuture.completedFuture(productVariantDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productVariantDraftAssets, this.assetReferenceResolver::resolveReferences, Collectors.toList()).thenApply(arg_0 -> ((ProductVariantDraftBuilder)productVariantDraftBuilder).assets(arg_0));
    }

    @Nonnull
    CompletionStage<ProductVariantDraftBuilder> resolvePricesReferences(@Nonnull ProductVariantDraftBuilder productVariantDraftBuilder) {
        List productVariantDraftPrices = productVariantDraftBuilder.getPrices();
        if (productVariantDraftPrices == null) {
            return CompletableFuture.completedFuture(productVariantDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(productVariantDraftPrices, this.priceReferenceResolver::resolveReferences, Collectors.toList()).thenApply(arg_0 -> ((ProductVariantDraftBuilder)productVariantDraftBuilder).prices(arg_0));
    }

    @Nonnull
    private CompletionStage<ProductVariantDraftBuilder> resolveAttributesReferences(@Nonnull ProductVariantDraftBuilder productVariantDraftBuilder) {
        List attributeDrafts = productVariantDraftBuilder.getAttributes();
        if (attributeDrafts == null) {
            return CompletableFuture.completedFuture(productVariantDraftBuilder);
        }
        return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(attributeDrafts, this::resolveAttributeReference, Collectors.toList()).thenApply(arg_0 -> ((ProductVariantDraftBuilder)productVariantDraftBuilder).attributes(arg_0));
    }

    @Nonnull
    private CompletionStage<Attribute> resolveAttributeReference(@Nonnull Attribute attributeDraft) {
        Object attributeDraftValue = attributeDraft.getValue();
        if (attributeDraftValue == null) {
            return CompletableFuture.completedFuture(attributeDraft);
        }
        JsonNode attributeDraftValueAsJson = AttributeUtils.replaceAttributeValueWithJsonAndReturnValue(attributeDraft);
        List<JsonNode> allAttributeReferences = AttributeUtils.getAttributeReferences(attributeDraftValueAsJson);
        if (!allAttributeReferences.isEmpty()) {
            return CompletableFutureUtils.mapValuesToFutureOfCompletedValues(allAttributeReferences, this::resolveReference, Collectors.toList()).thenApply(ignoredResult -> {
                if (AttributeUtils.cleanupAttributeValue(attributeDraftValueAsJson, attributeDraft).isEmpty()) {
                    return null;
                }
                return AttributeBuilder.of().name(attributeDraft.getName()).value((Object)attributeDraftValueAsJson).build();
            });
        }
        return CompletableFuture.completedFuture(attributeDraft);
    }

    @Nonnull
    private CompletionStage<Void> resolveReference(@Nonnull JsonNode referenceValue) {
        return this.getResolvedId(referenceValue).thenAccept(optionalId -> optionalId.ifPresent(id -> ((ObjectNode)referenceValue).put("id", id)));
    }

    @Nonnull
    private CompletionStage<Optional<String>> getResolvedId(@Nonnull JsonNode referenceValue) {
        if (ResourceIdentifierUtils.isReferenceOfType(referenceValue, "product")) {
            return this.getResolvedIdFromKeyInReference(referenceValue, this.productService::getIdFromCacheOrFetch);
        }
        if (ResourceIdentifierUtils.isReferenceOfType(referenceValue, "category")) {
            return this.getResolvedIdFromKeyInReference(referenceValue, this.categoryService::fetchCachedCategoryId);
        }
        if (ResourceIdentifierUtils.isReferenceOfType(referenceValue, "product-type")) {
            return this.getResolvedIdFromKeyInReference(referenceValue, this.productTypeService::fetchCachedProductTypeId);
        }
        if (ResourceIdentifierUtils.isReferenceOfType(referenceValue, "key-value-document")) {
            return this.getResolvedIdFromKeyInReference(referenceValue, this::resolveCustomObjectReference);
        }
        if (ResourceIdentifierUtils.isReferenceOfType(referenceValue, "state")) {
            return this.getResolvedIdFromKeyInReference(referenceValue, this.stateService::fetchCachedStateId);
        }
        if (ResourceIdentifierUtils.isReferenceOfType(referenceValue, "customer")) {
            return this.getResolvedIdFromKeyInReference(referenceValue, this.customerService::fetchCachedCustomerId);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Nonnull
    private CompletionStage<Optional<String>> getResolvedIdFromKeyInReference(@Nonnull JsonNode referenceValue, @Nonnull Function<String, CompletionStage<Optional<String>>> resolvedIdFetcher) {
        JsonNode idField = referenceValue.get("id");
        return idField != null && !Objects.equals(idField, NullNode.getInstance()) ? resolvedIdFetcher.apply(idField.asText()) : CompletableFuture.completedFuture(Optional.empty());
    }

    private CompletionStage<Optional<String>> resolveCustomObjectReference(@Nonnull String resolvedIdText) {
        if (SyncUtils.isUuid(resolvedIdText)) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        CustomObjectCompositeIdentifier customObjectCompositeIdentifier = CustomObjectCompositeIdentifier.of(resolvedIdText);
        return this.customObjectService.fetchCachedCustomObjectId(customObjectCompositeIdentifier);
    }
}

