/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.common.Asset;
import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.api.models.product.ProductChangeAssetNameAction;
import com.commercetools.api.models.product.ProductSetAssetDescriptionAction;
import com.commercetools.api.models.product.ProductSetAssetSourcesAction;
import com.commercetools.api.models.product.ProductSetAssetTagsAction;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.sync.commons.models.AssetCustomTypeAdapter;
import com.commercetools.sync.commons.models.AssetDraftCustomTypeAdapter;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.products.ProductSyncOptions;
import com.commercetools.sync.products.helpers.AssetCustomActionBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ProductVariantAssetUpdateActionUtils {
    @Nonnull
    public static <D> List<ProductUpdateAction> buildActions(@Nonnull D newResource, @Nonnull Long variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull ProductSyncOptions syncOptions) {
        List<ProductUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(ProductVariantAssetUpdateActionUtils.buildChangeAssetNameUpdateAction(variantId, oldAsset, newAsset), ProductVariantAssetUpdateActionUtils.buildSetAssetDescriptionUpdateAction(variantId, oldAsset, newAsset), ProductVariantAssetUpdateActionUtils.buildSetAssetTagsUpdateAction(variantId, oldAsset, newAsset), ProductVariantAssetUpdateActionUtils.buildSetAssetSourcesUpdateAction(variantId, oldAsset, newAsset));
        updateActions.addAll(ProductVariantAssetUpdateActionUtils.buildCustomUpdateActions(newResource, variantId, oldAsset, newAsset, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildChangeAssetNameUpdateAction(@Nonnull Long variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getName(), newAsset.getName(), () -> ProductChangeAssetNameAction.builder().assetKey(oldAsset.getKey()).variantId(variantId).name(newAsset.getName()).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetAssetDescriptionUpdateAction(@Nonnull Long variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getDescription(), newAsset.getDescription(), () -> ProductSetAssetDescriptionAction.builder().variantId(variantId).assetKey(oldAsset.getKey()).description(newAsset.getDescription()).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetAssetTagsUpdateAction(@Nonnull Long variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getTags(), newAsset.getTags(), () -> ProductSetAssetTagsAction.builder().variantId(variantId).assetKey(oldAsset.getKey()).tags(newAsset.getTags()).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static Optional<ProductUpdateAction> buildSetAssetSourcesUpdateAction(@Nonnull Long variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getSources(), newAsset.getSources(), () -> ProductSetAssetSourcesAction.builder().variantId(variantId).assetKey(oldAsset.getKey()).sources(newAsset.getSources()).staged(Boolean.valueOf(true)).build());
    }

    @Nonnull
    public static <D> List<ProductUpdateAction> buildCustomUpdateActions(@Nonnull D newResource, @Nonnull Long variantId, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull ProductSyncOptions syncOptions) {
        AssetCustomTypeAdapter assetCustomTypeAdapter = AssetCustomTypeAdapter.of(oldAsset);
        AssetDraftCustomTypeAdapter assetDraftCustomTypeAdapter = AssetDraftCustomTypeAdapter.of(newAsset);
        return CustomUpdateActionUtils.buildCustomUpdateActions(newResource, assetCustomTypeAdapter, assetDraftCustomTypeAdapter, new AssetCustomActionBuilder(), variantId, AssetCustomTypeAdapter::getId, AssetCustomTypeAdapter::getTypeId, AssetCustomTypeAdapter::getKey, syncOptions);
    }

    private ProductVariantAssetUpdateActionUtils() {
    }
}

