/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.helpers;

import com.commercetools.api.models.product_type.AttributeDefinition;
import com.commercetools.api.models.product_type.AttributeDefinitionDraftBuilder;
import com.commercetools.api.models.product_type.ProductType;
import com.commercetools.api.models.product_type.ProductTypeDraft;
import com.commercetools.api.models.product_type.ProductTypeDraftBuilder;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ResourceToDraftConverters {
    public static ProductTypeDraft toProductTypeDraft(@Nonnull ProductType productType) {
        return ResourceToDraftConverters.toProductTypeDraftBuilder(productType).build();
    }

    @Nonnull
    public static ProductTypeDraftBuilder toProductTypeDraftBuilder(@Nonnull ProductType productType) {
        return ProductTypeDraftBuilder.of().description(productType.getDescription()).key(productType.getKey()).name(productType.getName()).attributes(productType.getAttributes().stream().map(attributeDefinition -> ResourceToDraftConverters.toAttributeDefinitionDraftBuilder(attributeDefinition).build()).collect(Collectors.toList()));
    }

    @Nonnull
    public static AttributeDefinitionDraftBuilder toAttributeDefinitionDraftBuilder(@Nonnull AttributeDefinition attributeDefinition) {
        return AttributeDefinitionDraftBuilder.of().type(attributeDefinition.getType()).name(attributeDefinition.getName()).label(attributeDefinition.getLabel()).isSearchable(attributeDefinition.getIsSearchable()).inputTip(attributeDefinition.getInputTip()).isRequired(attributeDefinition.getIsRequired()).attributeConstraint(attributeDefinition.getAttributeConstraint()).inputHint(attributeDefinition.getInputHint());
    }
}

