/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.api.models.product_type.AttributeDefinition;
import com.commercetools.api.models.product_type.AttributeDefinitionDraft;
import com.commercetools.api.models.product_type.AttributeEnumType;
import com.commercetools.api.models.product_type.AttributeLocalizedEnumType;
import com.commercetools.api.models.product_type.AttributeReferenceType;
import com.commercetools.api.models.product_type.AttributeSetType;
import com.commercetools.api.models.product_type.AttributeType;
import com.commercetools.api.models.product_type.ProductTypeAddAttributeDefinitionActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeChangeAttributeOrderByNameActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeRemoveAttributeDefinitionActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeUpdateAction;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.DuplicateKeyException;
import com.commercetools.sync.commons.exceptions.DuplicateNameException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.producttypes.utils.AttributeDefinitionUpdateActionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class AttributeDefinitionsUpdateActionUtils {
    @Nonnull
    static List<ProductTypeUpdateAction> buildAttributeDefinitionsUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nullable List<AttributeDefinitionDraft> newAttributeDefinitionsDrafts) throws BuildUpdateActionException {
        if (newAttributeDefinitionsDrafts != null) {
            return AttributeDefinitionsUpdateActionUtils.buildUpdateActions(oldAttributeDefinitions, newAttributeDefinitionsDrafts.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return oldAttributeDefinitions.stream().map(AttributeDefinition::getName).map(name -> ProductTypeRemoveAttributeDefinitionActionBuilder.of().name(name).build()).collect(Collectors.toList());
    }

    @Nonnull
    private static List<ProductTypeUpdateAction> buildUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionsDrafts) throws BuildUpdateActionException {
        try {
            List<ProductTypeUpdateAction> updateActions = AttributeDefinitionsUpdateActionUtils.buildRemoveAttributeDefinitionOrAttributeDefinitionUpdateActions(oldAttributeDefinitions, newAttributeDefinitionsDrafts);
            updateActions.addAll(AttributeDefinitionsUpdateActionUtils.buildAddAttributeDefinitionUpdateActions(oldAttributeDefinitions, newAttributeDefinitionsDrafts));
            AttributeDefinitionsUpdateActionUtils.buildChangeAttributeDefinitionOrderUpdateAction(oldAttributeDefinitions, newAttributeDefinitionsDrafts).ifPresent(updateActions::add);
            return updateActions;
        }
        catch (DuplicateKeyException | DuplicateNameException | UnsupportedOperationException exception) {
            throw new BuildUpdateActionException(exception);
        }
    }

    @Nonnull
    private static List<ProductTypeUpdateAction> buildRemoveAttributeDefinitionOrAttributeDefinitionUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionsDrafts) {
        Map<String, AttributeDefinitionDraft> newAttributesDefinitionsDraftsNameMap = newAttributeDefinitionsDrafts.stream().collect(Collectors.toMap(AttributeDefinitionDraft::getName, attributeDefinitionDraft -> attributeDefinitionDraft, (attributeDefinitionDraftA, attributeDefinitionDraftB) -> {
            throw new DuplicateNameException(String.format("Attribute definitions drafts have duplicated names. Duplicated attribute definition name: '%s'. Attribute definitions names are expected to be unique inside their product type.", attributeDefinitionDraftA.getName()));
        }));
        return oldAttributeDefinitions.stream().map(oldAttributeDefinition -> {
            String oldAttributeDefinitionName = oldAttributeDefinition.getName();
            AttributeDefinitionDraft matchingNewAttributeDefinitionDraft = (AttributeDefinitionDraft)newAttributesDefinitionsDraftsNameMap.get(oldAttributeDefinitionName);
            if (matchingNewAttributeDefinitionDraft == null) {
                return Collections.singletonList(ProductTypeRemoveAttributeDefinitionActionBuilder.of().name(oldAttributeDefinitionName).build());
            }
            if (matchingNewAttributeDefinitionDraft.getType() != null) {
                if (AttributeDefinitionsUpdateActionUtils.haveSameAttributeType(oldAttributeDefinition.getType(), matchingNewAttributeDefinitionDraft.getType())) {
                    return AttributeDefinitionUpdateActionUtils.buildActions(oldAttributeDefinition, matchingNewAttributeDefinitionDraft);
                }
                throw new UnsupportedOperationException(String.format("Due to eventual consistency of 'removeAttributeDefinition' action, changing the attribute definition type (attribute name='%s') is not supported programmatically. Please apply the attribute definition type changes manually through commercetools API or merchant center. For more information please check: https://github.com/commercetools/commercetools-sync-java/blob/master/docs/adr/0003-syncing-attribute-type-changes.md", oldAttributeDefinitionName));
            }
            return new ArrayList();
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean haveSameAttributeType(@Nonnull AttributeType attributeTypeA, @Nonnull AttributeType attributeTypeB) {
        if (attributeTypeA instanceof AttributeSetType && attributeTypeB instanceof AttributeSetType) {
            return AttributeDefinitionsUpdateActionUtils.haveSameAttributeType(((AttributeSetType)attributeTypeA).getElementType(), ((AttributeSetType)attributeTypeB).getElementType());
        }
        if (attributeTypeA instanceof AttributeReferenceType && attributeTypeB instanceof AttributeReferenceType) {
            return attributeTypeA.equals(attributeTypeB);
        }
        if (attributeTypeA instanceof AttributeEnumType && attributeTypeB instanceof AttributeEnumType) {
            return true;
        }
        if (attributeTypeA instanceof AttributeLocalizedEnumType && attributeTypeB instanceof AttributeLocalizedEnumType) {
            return true;
        }
        return Objects.equals(attributeTypeA, attributeTypeB);
    }

    @Nonnull
    private static Optional<ProductTypeUpdateAction> buildChangeAttributeDefinitionOrderUpdateAction(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionDrafts) {
        List newNames = newAttributeDefinitionDrafts.stream().map(AttributeDefinitionDraft::getName).collect(Collectors.toList());
        List existingNames = oldAttributeDefinitions.stream().map(AttributeDefinition::getName).filter(newNames::contains).collect(Collectors.toList());
        List notExistingNames = newNames.stream().filter(newName -> !existingNames.contains(newName)).collect(Collectors.toList());
        List newAttributeDefinitionsOrder = newAttributeDefinitionDrafts.stream().map(AttributeDefinitionDraft::getName).collect(Collectors.toList());
        List allNames = Stream.concat(existingNames.stream(), notExistingNames.stream()).collect(Collectors.toList());
        return CommonTypeUpdateActionUtils.buildUpdateAction(allNames, newNames, () -> ProductTypeChangeAttributeOrderByNameActionBuilder.of().attributeNames(newAttributeDefinitionsOrder).build());
    }

    @Nonnull
    private static List<ProductTypeUpdateAction> buildAddAttributeDefinitionUpdateActions(@Nonnull List<AttributeDefinition> oldAttributeDefinitions, @Nonnull List<AttributeDefinitionDraft> newAttributeDefinitionDrafts) {
        Map<String, AttributeDefinition> oldAttributeDefinitionNameMap = oldAttributeDefinitions.stream().collect(Collectors.toMap(AttributeDefinition::getName, attributeDefinition -> attributeDefinition));
        return newAttributeDefinitionDrafts.stream().filter(attributeDefinitionDraft -> !oldAttributeDefinitionNameMap.containsKey(attributeDefinitionDraft.getName())).map(attributeDefinitionDraft -> ProductTypeAddAttributeDefinitionActionBuilder.of().attribute(attributeDefinitionDraft).build()).collect(Collectors.toList());
    }

    private AttributeDefinitionsUpdateActionUtils() {
    }
}

