/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.api.models.product_type.AttributeLocalizedEnumValue;
import com.commercetools.api.models.product_type.ProductTypeAddLocalizedEnumValueActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeChangeLocalizedEnumValueLabelActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeChangeLocalizedEnumValueOrderActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeRemoveEnumValuesActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.EnumValuesUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LocalizedEnumValueUpdateActionUtils {
    @Nonnull
    public static List<ProductTypeUpdateAction> buildLocalizedEnumValuesUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull List<AttributeLocalizedEnumValue> oldEnumValues, @Nullable List<AttributeLocalizedEnumValue> newEnumValues) {
        return EnumValuesUpdateActionUtils.buildActions(attributeDefinitionName, oldEnumValues, newEnumValues, (definitionName, keysToRemove) -> ProductTypeRemoveEnumValuesActionBuilder.of().attributeName(definitionName).keys(keysToRemove).build(), (definitionName, oldEnumValue, newEnumValue) -> LocalizedEnumValueUpdateActionUtils.buildLocalizedEnumValueUpdateActions(attributeDefinitionName, oldEnumValue, newEnumValue), (definitionName, newEnumValue) -> ProductTypeAddLocalizedEnumValueActionBuilder.of().attributeName(definitionName).value(newEnumValue).build(), (definitionName, newValues) -> ProductTypeChangeLocalizedEnumValueOrderActionBuilder.of().attributeName(definitionName).values(newValues).build(), null);
    }

    @Nonnull
    public static List<ProductTypeUpdateAction> buildLocalizedEnumValueUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull AttributeLocalizedEnumValue oldEnumValue, @Nonnull AttributeLocalizedEnumValue newEnumValue) {
        return OptionalUtils.filterEmptyOptionals(LocalizedEnumValueUpdateActionUtils.buildChangeLabelAction(attributeDefinitionName, oldEnumValue, newEnumValue));
    }

    @Nonnull
    private static Optional<ProductTypeUpdateAction> buildChangeLabelAction(@Nonnull String attributeDefinitionName, @Nonnull AttributeLocalizedEnumValue oldEnumValue, @Nonnull AttributeLocalizedEnumValue newEnumValue) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldEnumValue.getLabel(), newEnumValue.getLabel(), () -> ProductTypeChangeLocalizedEnumValueLabelActionBuilder.of().attributeName(attributeDefinitionName).newValue(newEnumValue).build());
    }

    private LocalizedEnumValueUpdateActionUtils() {
    }
}

