/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyChannelsByIDGet;
import com.commercetools.api.client.ByProjectKeyChannelsGet;
import com.commercetools.api.client.ByProjectKeyChannelsPost;
import com.commercetools.api.models.channel.Channel;
import com.commercetools.api.models.channel.ChannelDraft;
import com.commercetools.api.models.channel.ChannelDraftBuilder;
import com.commercetools.api.models.channel.ChannelPagedQueryResponse;
import com.commercetools.api.models.channel.ChannelRoleEnum;
import com.commercetools.api.predicates.query.channel.ChannelQueryBuilderDsl;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.services.ChannelService;
import com.commercetools.sync.services.impl.BaseService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class ChannelServiceImpl
extends BaseService<BaseSyncOptions, Channel, ChannelDraft, ByProjectKeyChannelsGet, ChannelPagedQueryResponse, ByProjectKeyChannelsByIDGet, Channel, ChannelQueryBuilderDsl, ByProjectKeyChannelsPost>
implements ChannelService {
    private final Set<ChannelRoleEnum> channelRoles;

    public ChannelServiceImpl(@Nonnull BaseSyncOptions syncOptions, @Nonnull Set<ChannelRoleEnum> channelRoles) {
        super(syncOptions);
        this.channelRoles = channelRoles;
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> channelKeys) {
        return super.cacheKeysToIdsUsingGraphQl(channelKeys, GraphQlQueryResource.CHANNELS);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedChannelId(@Nonnull String key) {
        ByProjectKeyChannelsGet query = this.syncOptions.getCtpClient().channels().get().withWhere((Object)"key = :key").withPredicateVar("key", (Object)key);
        return this.fetchCachedResourceId(key, resource -> resource.getKey(), query);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Channel>> createChannel(@Nonnull String key) {
        ChannelDraft channelDraft = ChannelDraftBuilder.of().key(key).roles(List.copyOf(this.channelRoles)).build();
        return super.createResource(channelDraft, ChannelDraft::getKey, Channel::getId, Function.identity(), () -> this.syncOptions.getCtpClient().channels().post(channelDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<Channel>> createAndCacheChannel(@Nonnull String key) {
        return this.createChannel(key).thenApply(channelOptional -> {
            channelOptional.ifPresent(channel -> this.keyToIdCache.put((Object)key, (Object)channel.getId()));
            return channelOptional;
        });
    }
}

