/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyCustomerGroupsGet;
import com.commercetools.api.client.ByProjectKeyCustomerGroupsKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyCustomerGroupsPost;
import com.commercetools.api.models.customer_group.CustomerGroup;
import com.commercetools.api.models.customer_group.CustomerGroupDraft;
import com.commercetools.api.models.customer_group.CustomerGroupPagedQueryResponse;
import com.commercetools.api.predicates.query.customer_group.CustomerGroupQueryBuilderDsl;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.impl.BaseService;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CustomerGroupServiceImpl
extends BaseService<BaseSyncOptions, CustomerGroup, CustomerGroupDraft, ByProjectKeyCustomerGroupsGet, CustomerGroupPagedQueryResponse, ByProjectKeyCustomerGroupsKeyByKeyGet, CustomerGroup, CustomerGroupQueryBuilderDsl, ByProjectKeyCustomerGroupsPost>
implements CustomerGroupService {
    public CustomerGroupServiceImpl(@Nonnull BaseSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> customerGroupKeys) {
        return super.cacheKeysToIdsUsingGraphQl(customerGroupKeys, GraphQlQueryResource.CUSTOMER_GROUPS);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<String>> fetchCachedCustomerGroupId(@Nonnull String key) {
        ByProjectKeyCustomerGroupsGet query = this.syncOptions.getCtpClient().customerGroups().get().withWhere((Object)"key in :keys").withPredicateVar("keys", Collections.singletonList(key));
        return this.fetchCachedResourceId(key, query);
    }

    @Nonnull
    CompletionStage<Optional<String>> fetchCachedResourceId(@Nullable String key, @Nonnull ByProjectKeyCustomerGroupsGet query) {
        return super.fetchCachedResourceId(key, resource -> resource.getKey(), query);
    }
}

