/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyShoppingListsGet;
import com.commercetools.api.client.ByProjectKeyShoppingListsKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyShoppingListsPost;
import com.commercetools.api.models.shopping_list.ShoppingList;
import com.commercetools.api.models.shopping_list.ShoppingListDraft;
import com.commercetools.api.models.shopping_list.ShoppingListPagedQueryResponse;
import com.commercetools.api.models.shopping_list.ShoppingListUpdateAction;
import com.commercetools.api.models.shopping_list.ShoppingListUpdateBuilder;
import com.commercetools.api.predicates.query.shopping_list.ShoppingListQueryBuilderDsl;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.ShoppingListService;
import com.commercetools.sync.services.impl.BaseService;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ShoppingListServiceImpl
extends BaseService<ShoppingListSyncOptions, ShoppingList, ShoppingListDraft, ByProjectKeyShoppingListsGet, ShoppingListPagedQueryResponse, ByProjectKeyShoppingListsKeyByKeyGet, ShoppingList, ShoppingListQueryBuilderDsl, ByProjectKeyShoppingListsPost>
implements ShoppingListService {
    public ShoppingListServiceImpl(@Nonnull ShoppingListSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Map<String, String>> cacheKeysToIds(@Nonnull Set<String> shoppingListKeys) {
        return super.cacheKeysToIdsUsingGraphQl(shoppingListKeys, GraphQlQueryResource.SHOPPING_LISTS);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<ShoppingList>> fetchMatchingShoppingListsByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingShoppingLists(keys);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ShoppingList>> fetchShoppingList(@Nullable String key) {
        return super.fetchResource(key, ((ShoppingListSyncOptions)this.syncOptions).getCtpClient().shoppingLists().withKey(key).get().addExpand((Object)"lineItems[*].variant"));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<ShoppingList>> createShoppingList(@Nonnull ShoppingListDraft shoppingListDraft) {
        return super.createResource(shoppingListDraft, ShoppingListDraft::getKey, ShoppingList::getId, Function.identity(), () -> ((ShoppingListSyncOptions)this.syncOptions).getCtpClient().shoppingLists().post(shoppingListDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<ShoppingList> updateShoppingList(@Nonnull ShoppingList shoppingList, @Nonnull List<ShoppingListUpdateAction> updateActions) {
        List<List<ShoppingListUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)shoppingList));
        for (List<ShoppingListUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedShoppingList -> ((ShoppingListSyncOptions)this.syncOptions).getCtpClient().shoppingLists().withId(updatedShoppingList.getId()).post(ShoppingListUpdateBuilder.of().actions(batch).version(updatedShoppingList.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }

    private CompletionStage<Set<ShoppingList>> fetchMatchingShoppingLists(@Nonnull Set<String> shoppingListKeys) {
        return super.fetchMatchingResources(shoppingListKeys, ShoppingList::getKey, keysNotCached -> {
            ByProjectKeyShoppingListsGet query = ((ShoppingListSyncOptions)this.syncOptions).getCtpClient().shoppingLists().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached).addExpand((Object)"lineItems[*].variant");
            return query;
        });
    }
}

