/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.utils;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.state.State;
import com.commercetools.api.models.state.StateDraft;
import com.commercetools.api.models.state.StateReference;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import com.commercetools.sync.states.utils.StateReferenceResolutionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class StateTransformUtils {
    @Nonnull
    public static CompletableFuture<List<StateDraft>> toStateDrafts(@Nonnull ProjectApiRoot client, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull List<State> states) {
        StateTransformServiceImpl stateTransformService = new StateTransformServiceImpl(client, referenceIdToKeyCache);
        return stateTransformService.toStateDrafts(states);
    }

    private static class StateTransformServiceImpl
    extends BaseTransformServiceImpl {
        StateTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
            super(ctpClient, referenceIdToKeyCache);
        }

        @Nonnull
        public CompletableFuture<List<StateDraft>> toStateDrafts(@Nonnull List<State> states) {
            return this.transformTransitionReference(states).thenApply(ignore -> StateReferenceResolutionUtils.mapToStateDrafts(states, this.referenceIdToKeyCache));
        }

        @Nonnull
        private CompletableFuture<Void> transformTransitionReference(@Nonnull List<State> states) {
            Set<String> setOfTransitionStateIds = states.stream().map(State::getTransitions).filter(Objects::nonNull).map(transitions -> transitions.stream().filter(Objects::nonNull).map(StateReference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(setOfTransitionStateIds, GraphQlQueryResource.STATES);
        }
    }
}

