/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.taxcategories.utils;

import com.commercetools.api.models.tax_category.TaxCategory;
import com.commercetools.api.models.tax_category.TaxCategoryChangeNameActionBuilder;
import com.commercetools.api.models.tax_category.TaxCategoryDraft;
import com.commercetools.api.models.tax_category.TaxCategorySetDescriptionActionBuilder;
import com.commercetools.api.models.tax_category.TaxCategoryUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.taxcategories.utils.TaxRatesUpdateActionUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class TaxCategoryUpdateActionUtils {
    private TaxCategoryUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<TaxCategoryUpdateAction> buildChangeNameAction(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTaxCategory.getName(), newTaxCategory.getName(), () -> TaxCategoryChangeNameActionBuilder.of().name(newTaxCategory.getName()).build());
    }

    @Nonnull
    public static Optional<TaxCategoryUpdateAction> buildSetDescriptionAction(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldTaxCategory.getDescription(), newTaxCategory.getDescription(), () -> TaxCategorySetDescriptionActionBuilder.of().description(newTaxCategory.getDescription()).build());
    }

    @Nonnull
    public static List<TaxCategoryUpdateAction> buildTaxRateUpdateActions(@Nonnull TaxCategory oldTaxCategory, @Nonnull TaxCategoryDraft newTaxCategory) {
        return TaxRatesUpdateActionUtils.buildTaxRatesUpdateActions(oldTaxCategory.getRates(), newTaxCategory.getRates());
    }
}

