/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.utils;

import com.commercetools.api.models.type.Type;
import com.commercetools.api.models.type.TypeChangeNameActionBuilder;
import com.commercetools.api.models.type.TypeDraft;
import com.commercetools.api.models.type.TypeSetDescriptionActionBuilder;
import com.commercetools.api.models.type.TypeUpdateAction;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.types.TypeSyncOptions;
import com.commercetools.sync.types.utils.FieldDefinitionsUpdateActionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class TypeUpdateActionUtils {
    @Nonnull
    public static Optional<TypeUpdateAction> buildChangeNameUpdateAction(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldType.getName(), newType.getName(), () -> TypeChangeNameActionBuilder.of().name(newType.getName()).build());
    }

    @Nonnull
    public static Optional<TypeUpdateAction> buildSetDescriptionUpdateAction(@Nonnull Type oldType, @Nonnull TypeDraft newType) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldType.getDescription(), newType.getDescription(), () -> TypeSetDescriptionActionBuilder.of().description(newType.getDescription()).build());
    }

    @Nonnull
    public static List<TypeUpdateAction> buildFieldDefinitionsUpdateActions(@Nonnull Type oldType, @Nonnull TypeDraft newType, @Nonnull TypeSyncOptions syncOptions) {
        try {
            return FieldDefinitionsUpdateActionUtils.buildFieldDefinitionsUpdateActions(oldType.getFieldDefinitions(), newType.getFieldDefinitions());
        }
        catch (BuildUpdateActionException exception) {
            syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build update actions for the field definitions of the type with the key '%s'. Reason: %s", newType.getKey(), exception), exception), oldType, newType, null);
            return Collections.emptyList();
        }
    }

    private TypeUpdateActionUtils() {
    }
}

