/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.utils;

import com.commercetools.api.models.cart_discount.CartDiscount;
import com.commercetools.api.models.cart_discount.CartDiscountChangeCartPredicateActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountChangeIsActiveActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountChangeNameActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountChangeRequiresDiscountCodeActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountChangeSortOrderActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountChangeStackingModeActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountChangeTargetActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountChangeValueActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountDraft;
import com.commercetools.api.models.cart_discount.CartDiscountSetDescriptionActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountSetValidFromActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountSetValidFromAndUntilActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountSetValidUntilActionBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountUpdateAction;
import com.commercetools.api.models.cart_discount.CartDiscountValueAbsolute;
import com.commercetools.api.models.cart_discount.CartDiscountValueAbsoluteDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueFixed;
import com.commercetools.api.models.cart_discount.CartDiscountValueFixedDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueGiftLineItem;
import com.commercetools.api.models.cart_discount.CartDiscountValueGiftLineItemDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueRelative;
import com.commercetools.api.models.cart_discount.CartDiscountValueRelativeDraft;
import com.commercetools.api.models.cart_discount.StackingMode;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class CartDiscountUpdateActionUtils {
    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeValueUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        if (oldCartDiscount.getValue() instanceof CartDiscountValueAbsolute && newCartDiscount.getValue() instanceof CartDiscountValueAbsoluteDraft) {
            CartDiscountValueAbsolute oldValue = (CartDiscountValueAbsolute)oldCartDiscount.getValue();
            CartDiscountValueAbsoluteDraft newValue = (CartDiscountValueAbsoluteDraft)newCartDiscount.getValue();
            return CartDiscountUpdateActionUtils.buildChangeAbsoluteValueUpdateAction(oldValue, newValue);
        }
        if (oldCartDiscount.getValue() instanceof CartDiscountValueGiftLineItem && newCartDiscount.getValue() instanceof CartDiscountValueGiftLineItemDraft) {
            CartDiscountValueGiftLineItem oldValue = (CartDiscountValueGiftLineItem)oldCartDiscount.getValue();
            CartDiscountValueGiftLineItemDraft newValue = (CartDiscountValueGiftLineItemDraft)newCartDiscount.getValue();
            return CartDiscountUpdateActionUtils.buildChangeGiftLineItemValueUpdateAction(oldValue, newValue);
        }
        if (oldCartDiscount.getValue() instanceof CartDiscountValueRelative && newCartDiscount.getValue() instanceof CartDiscountValueRelativeDraft) {
            CartDiscountValueRelative oldValue = (CartDiscountValueRelative)oldCartDiscount.getValue();
            CartDiscountValueRelativeDraft newValue = (CartDiscountValueRelativeDraft)newCartDiscount.getValue();
            return CartDiscountUpdateActionUtils.buildChangeRelativeValueUpdateAction(oldValue, newValue);
        }
        if (oldCartDiscount.getValue() instanceof CartDiscountValueFixed && newCartDiscount.getValue() instanceof CartDiscountValueFixedDraft) {
            CartDiscountValueFixed oldValue = (CartDiscountValueFixed)oldCartDiscount.getValue();
            CartDiscountValueFixedDraft newValue = (CartDiscountValueFixedDraft)newCartDiscount.getValue();
            return CartDiscountUpdateActionUtils.buildChangeFixedValueUpdateAction(oldValue, newValue);
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getValue(), newCartDiscount.getValue(), () -> CartDiscountChangeValueActionBuilder.of().value(newCartDiscount.getValue()).build());
    }

    private static Optional<CartDiscountUpdateAction> buildChangeFixedValueUpdateAction(CartDiscountValueFixed oldValue, CartDiscountValueFixedDraft newValue) {
        return oldValue.getMoney().equals(newValue.getMoney()) ? Optional.empty() : Optional.of(CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
    }

    private static Optional<CartDiscountUpdateAction> buildChangeRelativeValueUpdateAction(CartDiscountValueRelative oldValue, CartDiscountValueRelativeDraft newValue) {
        return oldValue.getPermyriad().equals(newValue.getPermyriad()) ? Optional.empty() : Optional.of(CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
    }

    private static Optional<CartDiscountUpdateAction> buildChangeGiftLineItemValueUpdateAction(CartDiscountValueGiftLineItem oldValue, CartDiscountValueGiftLineItemDraft newValue) {
        return Optional.ofNullable(CartDiscountUpdateActionUtils.buildActionIfDifferentProducts(oldValue, newValue).orElse(CartDiscountUpdateActionUtils.buildActionIfDifferentProductVariantIds(oldValue, newValue).orElse(CartDiscountUpdateActionUtils.buildActionIfDifferentSupplyChannels(oldValue, newValue).orElse(CartDiscountUpdateActionUtils.buildActionIfDifferentDistributionChannels(oldValue, newValue).orElse(null)))));
    }

    @Nonnull
    private static Optional<CartDiscountUpdateAction> buildActionIfDifferentProducts(@Nonnull CartDiscountValueGiftLineItem oldValue, @Nonnull CartDiscountValueGiftLineItemDraft newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldValue.getProduct(), newValue.getProduct(), () -> CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
    }

    @Nonnull
    private static Optional<CartDiscountUpdateAction> buildActionIfDifferentProductVariantIds(@Nonnull CartDiscountValueGiftLineItem oldValue, @Nonnull CartDiscountValueGiftLineItemDraft newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldValue.getVariantId(), newValue.getVariantId(), () -> CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
    }

    @Nonnull
    private static Optional<CartDiscountUpdateAction> buildActionIfDifferentSupplyChannels(@Nonnull CartDiscountValueGiftLineItem oldValue, @Nonnull CartDiscountValueGiftLineItemDraft newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldValue.getSupplyChannel(), newValue.getSupplyChannel(), () -> CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
    }

    @Nonnull
    private static Optional<CartDiscountUpdateAction> buildActionIfDifferentDistributionChannels(@Nonnull CartDiscountValueGiftLineItem oldValue, @Nonnull CartDiscountValueGiftLineItemDraft newValue) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldValue.getDistributionChannel(), newValue.getDistributionChannel(), () -> CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
    }

    @Nonnull
    private static Optional<CartDiscountUpdateAction> buildChangeAbsoluteValueUpdateAction(@Nonnull CartDiscountValueAbsolute oldValue, @Nonnull CartDiscountValueAbsoluteDraft newValue) {
        if (newValue.getMoney() == null) {
            return Optional.of(CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
        }
        if (oldValue.getMoney().size() != newValue.getMoney().size()) {
            return Optional.of(CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
        }
        boolean allOldValuesFoundInNewValues = oldValue.getMoney().stream().allMatch(oldAmount -> newValue.getMoney().stream().filter(newAmount -> newAmount.getCurrency().equals(oldAmount.getCurrency())).anyMatch(newAmount -> newAmount.getCentAmount().equals(oldAmount.getCentAmount())));
        return allOldValuesFoundInNewValues ? Optional.empty() : Optional.of(CartDiscountChangeValueActionBuilder.of().value((CartDiscountValueDraft)newValue).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeCartPredicateUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getCartPredicate(), newCartDiscount.getCartPredicate(), () -> CartDiscountChangeCartPredicateActionBuilder.of().cartPredicate(newCartDiscount.getCartPredicate()).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeTargetUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getTarget(), newCartDiscount.getTarget(), () -> CartDiscountChangeTargetActionBuilder.of().target(newCartDiscount.getTarget()).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeIsActiveUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        Boolean isActive = Optional.ofNullable(newCartDiscount.getIsActive()).orElse(true);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getIsActive(), isActive, () -> CartDiscountChangeIsActiveActionBuilder.of().isActive(isActive).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeNameUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getName(), newCartDiscount.getName(), () -> CartDiscountChangeNameActionBuilder.of().name(newCartDiscount.getName()).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildSetDescriptionUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getDescription(), newCartDiscount.getDescription(), () -> CartDiscountSetDescriptionActionBuilder.of().description(newCartDiscount.getDescription()).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeSortOrderUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getSortOrder(), newCartDiscount.getSortOrder(), () -> CartDiscountChangeSortOrderActionBuilder.of().sortOrder(newCartDiscount.getSortOrder()).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeRequiresDiscountCodeUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        Boolean requiresDiscountCode = Optional.ofNullable(newCartDiscount.getRequiresDiscountCode()).orElse(false);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getRequiresDiscountCode(), requiresDiscountCode, () -> CartDiscountChangeRequiresDiscountCodeActionBuilder.of().requiresDiscountCode(requiresDiscountCode).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildSetValidFromUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getValidFrom(), newCartDiscount.getValidFrom(), () -> CartDiscountSetValidFromActionBuilder.of().validFrom(newCartDiscount.getValidFrom()).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildSetValidUntilUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getValidUntil(), newCartDiscount.getValidUntil(), () -> CartDiscountSetValidUntilActionBuilder.of().validUntil(newCartDiscount.getValidUntil()).build());
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildSetValidDatesUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        Optional<CartDiscountUpdateAction> setValidFromUpdateAction = CartDiscountUpdateActionUtils.buildSetValidFromUpdateAction(oldCartDiscount, newCartDiscount);
        Optional<CartDiscountUpdateAction> setValidUntilUpdateAction = CartDiscountUpdateActionUtils.buildSetValidUntilUpdateAction(oldCartDiscount, newCartDiscount);
        if (setValidFromUpdateAction.isPresent() && setValidUntilUpdateAction.isPresent()) {
            return Optional.of(CartDiscountSetValidFromAndUntilActionBuilder.of().validFrom(newCartDiscount.getValidFrom()).validUntil(newCartDiscount.getValidUntil()).build());
        }
        return setValidFromUpdateAction.isPresent() ? setValidFromUpdateAction : setValidUntilUpdateAction;
    }

    @Nonnull
    public static Optional<CartDiscountUpdateAction> buildChangeStackingModeUpdateAction(@Nonnull CartDiscount oldCartDiscount, @Nonnull CartDiscountDraft newCartDiscount) {
        StackingMode stackingMode = Optional.ofNullable(newCartDiscount.getStackingMode()).orElse(StackingMode.STACKING);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCartDiscount.getStackingMode(), stackingMode, () -> CartDiscountChangeStackingModeActionBuilder.of().stackingMode(stackingMode).build());
    }

    private CartDiscountUpdateActionUtils() {
    }
}

