/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.api.models.category.CategoryChangeAssetNameActionBuilder;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategorySetAssetDescriptionActionBuilder;
import com.commercetools.api.models.category.CategorySetAssetSourcesActionBuilder;
import com.commercetools.api.models.category.CategorySetAssetTagsActionBuilder;
import com.commercetools.api.models.category.CategoryUpdateAction;
import com.commercetools.api.models.common.Asset;
import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.api.models.type.ResourceTypeId;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.AssetCustomActionBuilder;
import com.commercetools.sync.commons.models.AssetCustomTypeAdapter;
import com.commercetools.sync.commons.models.AssetDraftCustomTypeAdapter;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class CategoryAssetUpdateActionUtils {
    @Nonnull
    public static List<CategoryUpdateAction> buildActions(@Nonnull CategoryDraft newResource, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull CategorySyncOptions syncOptions) {
        List<CategoryUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(CategoryAssetUpdateActionUtils.buildChangeAssetNameUpdateAction(oldAsset, newAsset), CategoryAssetUpdateActionUtils.buildSetAssetDescriptionUpdateAction(oldAsset, newAsset), CategoryAssetUpdateActionUtils.buildSetAssetTagsUpdateAction(oldAsset, newAsset), CategoryAssetUpdateActionUtils.buildSetAssetSourcesUpdateAction(oldAsset, newAsset));
        updateActions.addAll(CategoryAssetUpdateActionUtils.buildCustomUpdateActions(newResource, oldAsset, newAsset, syncOptions));
        return updateActions;
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildChangeAssetNameUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getName(), newAsset.getName(), () -> CategoryChangeAssetNameActionBuilder.of().assetKey(oldAsset.getKey()).name(newAsset.getName()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetAssetDescriptionUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getDescription(), newAsset.getDescription(), () -> CategorySetAssetDescriptionActionBuilder.of().assetKey(oldAsset.getKey()).description(newAsset.getDescription()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetAssetTagsUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getTags(), newAsset.getTags(), () -> CategorySetAssetTagsActionBuilder.of().assetKey(oldAsset.getKey()).tags(newAsset.getTags()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetAssetSourcesUpdateAction(@Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAsset.getSources(), newAsset.getSources(), () -> CategorySetAssetSourcesActionBuilder.of().assetKey(oldAsset.getKey()).sources(newAsset.getSources()).build());
    }

    @Nonnull
    public static List<CategoryUpdateAction> buildCustomUpdateActions(@Nonnull CategoryDraft newCategory, @Nonnull Asset oldAsset, @Nonnull AssetDraft newAsset, @Nonnull CategorySyncOptions syncOptions) {
        return CustomUpdateActionUtils.buildCustomUpdateActions(newCategory, AssetCustomTypeAdapter.of(oldAsset), AssetDraftCustomTypeAdapter.of(newAsset), new AssetCustomActionBuilder(), -1L, AssetCustomTypeAdapter::getId, asset -> ResourceTypeId.ASSET.getJsonName(), AssetCustomTypeAdapter::getKey, syncOptions);
    }

    private CategoryAssetUpdateActionUtils() {
    }
}

