/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.client.PagedQueryResourceRequest;
import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.graph_ql.GraphQLRequest;
import com.commercetools.api.models.graph_ql.GraphQLResponse;
import com.commercetools.sync.commons.utils.CompletableFutureUtils;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ChunkUtils {
    public static <ResourceT extends PagedQueryResourceRequest<ResourceT, ResultT, QueryBuilderDslT>, ResultT, QueryBuilderDslT> CompletableFuture<List<ApiHttpResponse<ResultT>>> executeChunks(@Nonnull List<ResourceT> requests) {
        List futures = requests.stream().map(request -> request.execute()).collect(Collectors.toList());
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList());
    }

    public static CompletableFuture<List<ApiHttpResponse<GraphQLResponse>>> executeChunks(@Nonnull ProjectApiRoot ctpClient, @Nonnull List<GraphQLRequest> requests) {
        List futures = requests.stream().map(request -> ctpClient.graphql().post(request).execute()).collect(Collectors.toList());
        return CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList());
    }

    public static <T> List<List<T>> chunk(@Nonnull Collection<T> elements, int chunkSize) {
        AtomicInteger index = new AtomicInteger(0);
        return new ArrayList<List<T>>(elements.stream().collect(Collectors.groupingBy(x -> index.getAndIncrement() / chunkSize)).values());
    }
}

